/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.NullLiteral;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Maps;
import com.google.caja.util.Strings;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class FlashRewriter {
    final Block embedder = new Block();
    final Jobs jobs;
    final MessageQueue mq;
    private static final String HTML_NS = "http://www.w3.org/1999/xhtml";
    private static final String APPLICATION_FLASH = "application/x-shockwave-flash";
    private static final String CLASSID_FLASH = "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000";

    FlashRewriter(Jobs jobs) {
        this.jobs = jobs;
        this.mq = jobs.getMessageQueue();
    }

    void finish() {
        if (this.embedder.children().size() != 0) {
            URI baseUri = null;
            this.jobs.getJobs().add(JobEnvelope.of(Job.jsJob(this.embedder, baseUri)));
        }
    }

    void rewriteChildren(Node node) {
        for (Node c = node.getFirstChild(); c != null; c = c.getNextSibling()) {
            if (c instanceof Element) {
                c = this.rewriteElement((Element)c);
            }
            this.rewriteChildren(c);
        }
    }

    private Element rewriteElement(Element el) {
        String tagName = Strings.lower(el.getLocalName());
        if ("embed".equals(tagName)) {
            if (APPLICATION_FLASH.equals(this.getAttr(el, "type"))) {
                return this.rewriteEmbed(el);
            }
        } else {
            if ("noembed".equals(tagName)) {
                return this.rewriteNoembed(el);
            }
            if ("object".equals(tagName)) {
                if (APPLICATION_FLASH.equals(this.getAttr(el, "type"))) {
                    return this.rewriteObject(el);
                }
                if (Strings.eqIgnoreCase(CLASSID_FLASH, this.getAttr(el, "classid"))) {
                    return this.rewriteObject(el);
                }
            }
        }
        return el;
    }

    private Element rewriteEmbed(Element el) {
        String src = this.getAttr(el, "src");
        if (this.empty(src)) {
            this.mq.addMessage((MessageTypeInt)Messages.MISSING_SRC, Nodes.getFilePositionFor(el));
            return el;
        }
        String height = this.getAttr(el, "height");
        String width = this.getAttr(el, "width");
        Element r = this.emplacehold(el);
        if (r == null) {
            this.mq.addMessage((MessageTypeInt)Messages.NO_PARENT, Nodes.getFilePositionFor(el));
            return el;
        }
        String id = this.getPlaceholderId(r);
        FilePosition pos = Nodes.getFilePositionFor(el);
        Expression e = (Expression)QuasiBuilder.substV("IMPORTS___.htmlEmitter___./*@synthetic*/ handleEmbed({ id: @id, src: @src, height: @height, width: @width })", "id", this.literal(id, pos), "src", this.literal(src, pos), "height", this.literal(height, pos), "width", this.literal(width, pos));
        this.embedder.appendChild(new ExpressionStmt(e));
        return r;
    }

    private Element rewriteNoembed(Element el) {
        String id = this.generateId();
        String className = el.getAttributeNS(HTML_NS, "class");
        className = this.empty(className) ? id : id + " " + className;
        el.setAttributeNS(HTML_NS, "class", className);
        FilePosition pos = Nodes.getFilePositionFor(el);
        Expression e = (Expression)QuasiBuilder.substV("IMPORTS___.htmlEmitter___./*@synthetic*/ handleEmbed({ id: @id })", "id", this.literal(id, pos));
        this.embedder.appendChild(new ExpressionStmt(e));
        return el;
    }

    private Element rewriteObject(Element el) {
        String height;
        String width;
        Element r = this.emplacehold(el);
        if (r == null) {
            this.mq.addMessage((MessageTypeInt)Messages.NO_PARENT, Nodes.getFilePositionFor(el));
            return el;
        }
        Map<String, String> params = Maps.newHashMap();
        Node c = el.getFirstChild();
        Node next = null;
        while (c != null) {
            next = c.getNextSibling();
            String tagName = this.getTagName(c);
            if ("param".equals(tagName)) {
                String name = this.getAttr(c, "name");
                String value = this.getAttr(c, "value");
                if (!this.empty(name) && !this.empty(value)) {
                    params.put(name, value);
                }
                c.getParentNode().removeChild(c);
            } else {
                r.appendChild(c);
            }
            c = next;
        }
        String src = this.getAttr(el, "data");
        if (this.empty(src)) {
            src = (String)params.get("movie");
        }
        if (this.empty(width = this.getAttr(el, "width"))) {
            width = (String)params.get("width");
        }
        if (this.empty(height = this.getAttr(el, "height"))) {
            height = (String)params.get("height");
        }
        String id = this.getPlaceholderId(r);
        FilePosition pos = Nodes.getFilePositionFor(el);
        Expression e = (Expression)QuasiBuilder.substV("IMPORTS___.htmlEmitter___./*@synthetic*/ handleEmbed({ id: @id, src: @src, height: @height, width: @width })", "id", this.literal(id, pos), "src", this.literal(src, pos), "height", this.literal(height, pos), "width", this.literal(width, pos));
        this.embedder.appendChild(new ExpressionStmt(e));
        return r;
    }

    private Literal literal(String value, FilePosition pos) {
        if (this.empty(value)) {
            return new NullLiteral(pos);
        }
        return StringLiteral.valueOf(pos, value);
    }

    private Element emplacehold(Element el) {
        Node parent = el.getParentNode();
        if (parent == null) {
            return null;
        }
        Element span = el.getOwnerDocument().createElementNS(HTML_NS, "span");
        span.setAttributeNS(HTML_NS, "class", this.generateId());
        parent.insertBefore(span, el);
        parent.removeChild(el);
        return span;
    }

    private String getTagName(Node n) {
        if (n instanceof Element) {
            return Strings.lower(n.getLocalName());
        }
        return null;
    }

    private String getAttr(Node n, String attrib) {
        if (n instanceof Element) {
            return ((Element)n).getAttributeNS(HTML_NS, attrib);
        }
        return null;
    }

    private boolean empty(String s) {
        return s == null || s.length() == 0;
    }

    private String generateId() {
        int guid = this.jobs.getPluginMeta().generateGuid();
        return "cajaEmbed" + guid;
    }

    private String getPlaceholderId(Element el) {
        return el.getAttributeNS(HTML_NS, "class");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Messages implements MessageTypeInt
    {
        MISSING_SRC(MessageLevel.WARNING, "%s: Embed is missing src attribute"),
        NO_PARENT(MessageLevel.WARNING, "%s: Element doesn't have a parent??");

        private final String formatString;
        private final MessageLevel level;
        private int paramCount = -1;

        private Messages(MessageLevel level, String formatString) {
            this.level = level;
            this.formatString = formatString;
        }

        @Override
        public int getParamCount() {
            if (this.paramCount < 0) {
                this.paramCount = MessageType.formatStringArity(this.formatString);
            }
            return this.paramCount;
        }

        @Override
        public void format(MessagePart[] parts, MessageContext context, Appendable out) throws IOException {
            MessageType.formatMessage(this.formatString, parts, context, out);
        }

        @Override
        public MessageLevel getLevel() {
            return this.level;
        }
    }
}

