/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.gadget.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.config.ContainerConfigELResolver;
import org.apache.shindig.config.ContainerConfigException;
import org.apache.shindig.config.DynamicConfigProperty;
import org.apache.shindig.config.ExpressionContainerConfig;
import org.apache.shindig.expressions.Expressions;
import org.exoplatform.container.RootContainer;
import org.exoplatform.portal.gadget.core.GateInContainerConfigLoader;
import org.exoplatform.portal.gadget.core.GateInGuiceServletContextListener;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Singleton
public class GateInJsonContainerConfig
extends ExpressionContainerConfig {
    private static final Logger LOG = Logger.getLogger(GateInJsonContainerConfig.class.getName());
    public static final char FILE_SEPARATOR = ',';
    public static final String PARENT_KEY = "parent";
    public static final String CONTAINER_KEY = "gadgets.container";
    private final Map<String, Map<String, Object>> config;
    private final Expressions expressions;

    @Inject
    public GateInJsonContainerConfig(@Named(value="shindig.containers.default") String containers, Expressions expressions) throws ContainerConfigException {
        super(expressions);
        this.expressions = expressions;
        this.config = this.createContainers(this.loadContainers(containers));
        this.init();
    }

    public GateInJsonContainerConfig(JSONObject json, Expressions expressions) {
        super(expressions);
        this.expressions = expressions;
        this.config = this.createContainers(json);
        this.init();
    }

    protected void init() {
        for (Map.Entry<String, Map<String, Object>> configEntry : this.config.entrySet()) {
            Map value = (Map)this.evaluateAll(configEntry.getValue());
            configEntry.setValue(value);
        }
    }

    public Collection<String> getContainers() {
        return Collections.unmodifiableSet(this.config.keySet());
    }

    public Map<String, Object> getProperties(String container) {
        Map<String, Object> pros = this.config.get(container);
        if (pros == null && RootContainer.getInstance().getPortalContainer(container) != null) {
            pros = this.config.get("default");
        }
        return pros;
    }

    public Object getProperty(String container, String property) {
        if (property.startsWith("${")) {
            try {
                ValueExpression expression = this.expressions.parse(property, Object.class);
                return expression.getValue(this.createExpressionContext(container));
            }
            catch (ELException e) {
                return null;
            }
        }
        Map<String, Object> containerData = this.getProperties(container);
        if (containerData == null) {
            return null;
        }
        return containerData.get(property);
    }

    private Map<String, Map<String, Object>> createContainers(JSONObject json) {
        HashMap map = Maps.newHashMap();
        for (String container : JSONObject.getNames((JSONObject)json)) {
            ELContext context = this.createExpressionContext(container);
            map.put(container, GateInJsonContainerConfig.jsonToMap(json.optJSONObject(container), this.expressions, context));
        }
        return map;
    }

    protected Expressions getExpressions() {
        return this.expressions;
    }

    protected ELContext createExpressionContext(String container) {
        return this.getExpressions().newELContext(new ELResolver[]{new ContainerConfigELResolver((ContainerConfig)this, container)});
    }

    private static Object jsonToConfig(Object json, Expressions expressions, ELContext context) {
        if (JSONObject.NULL.equals(json)) {
            return null;
        }
        if (json instanceof CharSequence) {
            return new DynamicConfigProperty(json.toString(), expressions, context);
        }
        if (json instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)json;
            ArrayList<Object> values = new ArrayList<Object>(jsonArray.length());
            int j = jsonArray.length();
            for (int i = 0; i < j; ++i) {
                values.add(GateInJsonContainerConfig.jsonToConfig(jsonArray.opt(i), expressions, context));
            }
            return Collections.unmodifiableList(values);
        }
        if (json instanceof JSONObject) {
            return GateInJsonContainerConfig.jsonToMap((JSONObject)json, expressions, context);
        }
        return json;
    }

    private static Map<String, Object> jsonToMap(JSONObject json, Expressions expressions, ELContext context) {
        HashMap<String, Object> values = new HashMap<String, Object>(json.length(), 1.0f);
        for (String key : JSONObject.getNames((JSONObject)json)) {
            Object val = GateInJsonContainerConfig.jsonToConfig(json.opt(key), expressions, context);
            if (val == null) continue;
            values.put(key, val);
        }
        return Collections.unmodifiableMap(values);
    }

    private void loadFiles(File[] files, JSONObject all) throws ContainerConfigException {
        try {
            for (File file : files) {
                LOG.info("Reading container config: " + file.getName());
                if (file.isDirectory()) {
                    this.loadFiles(file.listFiles(), all);
                    continue;
                }
                if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".js") || file.getName().toLowerCase(Locale.ENGLISH).endsWith(".json")) {
                    if (!file.exists()) {
                        throw new ContainerConfigException("The file '" + file.getAbsolutePath() + "' doesn't exist.");
                    }
                    this.loadFromString(ResourceLoader.getContent((File)file), all);
                    continue;
                }
                if (!LOG.isLoggable(Level.FINEST)) continue;
                LOG.finest(file.getAbsolutePath() + " doesn't seem to be a JS or JSON file.");
            }
        }
        catch (IOException e) {
            throw new ContainerConfigException((Throwable)e);
        }
    }

    private void loadResources(String[] files, JSONObject all) throws ContainerConfigException {
        try {
            for (String entry : files) {
                LOG.info("Reading container config: " + entry);
                GateInContainerConfigLoader currentLoader = GateInGuiceServletContextListener.getCurrentLoader();
                String content = currentLoader.loadContentAsString(entry, "UTF-8");
                if (content == null) {
                    LOG.warning("There is no configuration file " + entry + " in Gadget Server context");
                    content = ResourceLoader.getContent((String)entry);
                    if (content == null || content.length() == 0) {
                        throw new IOException("The file " + entry + " is empty");
                    }
                }
                this.loadFromString(content, all);
            }
        }
        catch (IOException e) {
            throw new ContainerConfigException((Throwable)e);
        }
    }

    private JSONObject mergeObjects(JSONObject base, JSONObject merge) throws JSONException {
        String[] fields;
        JSONObject clone = new JSONObject(base, JSONObject.getNames((JSONObject)base));
        for (String field : fields = JSONObject.getNames((JSONObject)merge)) {
            Object existing = clone.opt(field);
            Object update = merge.get(field);
            if (JSONObject.NULL.equals(existing) || JSONObject.NULL.equals(update)) {
                clone.put(field, update);
                continue;
            }
            if (update instanceof JSONObject && existing instanceof JSONObject) {
                clone.put(field, (Object)this.mergeObjects((JSONObject)existing, (JSONObject)update));
                continue;
            }
            clone.put(field, update);
        }
        return clone;
    }

    private JSONObject mergeParents(String container, JSONObject all) throws ContainerConfigException, JSONException {
        JSONObject base = all.getJSONObject(container);
        if ("default".equals(container)) {
            return base;
        }
        String parent = base.optString(PARENT_KEY, "default");
        if (!all.has(parent)) {
            throw new ContainerConfigException("Unable to locate parent '" + parent + "' required by " + base.getString(CONTAINER_KEY));
        }
        return this.mergeObjects(this.mergeParents(parent, all), base);
    }

    protected void loadFromString(String json, JSONObject all) throws ContainerConfigException {
        try {
            JSONObject contents = new JSONObject(json);
            JSONArray containers = contents.getJSONArray(CONTAINER_KEY);
            int j = containers.length();
            for (int i = 0; i < j; ++i) {
                String container = containers.getString(i);
                all.put(container, (Object)contents);
            }
        }
        catch (JSONException e) {
            throw new ContainerConfigException((Throwable)e);
        }
    }

    private JSONObject loadContainers(String path) throws ContainerConfigException {
        JSONObject all = new JSONObject();
        try {
            for (String location : StringUtils.split((String)path, (char)',')) {
                if (location.startsWith("res://")) {
                    location = location.substring(6);
                    LOG.info("Loading resources from: " + location);
                    if (path.endsWith(".txt")) {
                        this.loadResources(ResourceLoader.getContent((String)location).split("[\r\n]+"), all);
                        continue;
                    }
                    this.loadResources(new String[]{location}, all);
                    continue;
                }
                LOG.info("Loading files from: " + location);
                File file = new File(location);
                this.loadFiles(new File[]{file}, all);
            }
            for (String container : JSONObject.getNames((JSONObject)all)) {
                all.put(container, (Object)this.mergeParents(container, all));
            }
            return all;
        }
        catch (IOException e) {
            throw new ContainerConfigException((Throwable)e);
        }
        catch (JSONException e) {
            throw new ContainerConfigException((Throwable)e);
        }
    }

    public String toString() {
        return JsonSerializer.serialize(this.config);
    }

    private Object evaluateAll(Object value) {
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof Map) {
            ImmutableMap.Builder newMap = ImmutableMap.builder();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                newMap.put(entry.getKey(), this.evaluateAll(entry.getValue()));
            }
            return newMap.build();
        }
        if (value instanceof List) {
            ImmutableList.Builder newList = ImmutableList.builder();
            for (Object entry : (List)value) {
                newList.add(this.evaluateAll(entry));
            }
            return newList.build();
        }
        return value;
    }
}

