/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.settings.data;

import java.io.Serializable;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Tools;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SettingContext
implements Serializable {
    private static final Log LOG = ExoLogger.getLogger(SettingContext.class);
    private static final long serialVersionUID = 437625857263645213L;
    protected String repositoryName;
    protected Context context;
    protected String ContextPath;

    public SettingContext(Context context) {
        this.context = context;
        this.repositoryName = SettingContext.getCurrentRepositoryName();
        this.ContextPath = Tools.buildContextPath(context);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof SettingContext) {
            SettingContext dest = (SettingContext)obj;
            if (this.repositoryName == null) {
                return this.getContextPath().equals(dest.getContextPath());
            }
            return this.repositoryName.equals(dest.getRepositoryName()) && this.getContextPath().equals(dest.getContextPath());
        }
        return false;
    }

    public int hashCode() {
        int result = this.repositoryName == null ? 0 : this.repositoryName.hashCode();
        result = 31 * result + this.ContextPath.hashCode();
        return result;
    }

    public String getContextPath() {
        return this.ContextPath;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public Context getContext() {
        return this.context;
    }

    public static String getCurrentRepositoryName() {
        RepositoryService repositoryService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        try {
            if (repositoryService == null || repositoryService.getCurrentRepository() == null || repositoryService.getCurrentRepository().getConfiguration() == null) {
                return null;
            }
            return repositoryService.getCurrentRepository().getConfiguration().getName();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)"An error occurred when getting current repository name, null will be returned", (Throwable)e);
            }
            return null;
        }
    }
}

