/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.social.core.oauth2.OAuth2Client;
import org.apache.shindig.social.core.oauth2.OAuth2Code;
import org.apache.shindig.social.core.oauth2.OAuth2DataService;
import org.apache.shindig.social.core.oauth2.OAuth2Types;
import org.json.JSONException;
import org.json.JSONObject;

public class OAuth2DataServiceImpl
implements OAuth2DataService {
    private JSONObject oauthDB;
    private BeanConverter converter;
    private List<OAuth2Client> clients;
    private Map<String, List<OAuth2Code>> authCodes;
    private Map<String, List<OAuth2Code>> accessTokens;

    @Inject
    public OAuth2DataServiceImpl(@Named(value="shindig.canonical.json.db") String jsonLocation, @Named(value="shindig.bean.converter.json") BeanConverter converter, @Named(value="shindig.contextroot") String contextroot) throws Exception {
        String content = IOUtils.toString((InputStream)ResourceLoader.openResource((String)jsonLocation), (String)"UTF-8");
        content = content.replace("%contextRoot%", contextroot);
        this.oauthDB = new JSONObject(content).getJSONObject("oauth2");
        this.converter = converter;
        this.clients = Lists.newArrayList();
        this.authCodes = Maps.newHashMap();
        this.accessTokens = Maps.newHashMap();
        this.loadClientsFromCanonical();
    }

    @Override
    public OAuth2Client getClient(String clientId) {
        for (OAuth2Client client : this.clients) {
            if (!client.getId().equals(clientId)) continue;
            return client;
        }
        return null;
    }

    @Override
    public OAuth2Code getAuthorizationCode(String clientId, String authCode) {
        if (this.authCodes.containsKey(clientId)) {
            List<OAuth2Code> codes = this.authCodes.get(clientId);
            for (OAuth2Code code : codes) {
                if (!code.getValue().equals(authCode)) continue;
                return code;
            }
        }
        return null;
    }

    @Override
    public void registerAuthorizationCode(String clientId, OAuth2Code authCode) {
        if (this.authCodes.containsKey(clientId)) {
            this.authCodes.get(clientId).add(authCode);
        } else {
            ArrayList list = Lists.newArrayList();
            list.add(authCode);
            this.authCodes.put(clientId, list);
        }
    }

    @Override
    public void unregisterAuthorizationCode(String clientId, String authCode) {
        if (this.authCodes.containsKey(clientId)) {
            List<OAuth2Code> codes = this.authCodes.get(clientId);
            for (OAuth2Code code : codes) {
                if (!code.getValue().equals(authCode)) continue;
                codes.remove(code);
                return;
            }
        }
        throw new RuntimeException("signature not found");
    }

    @Override
    public OAuth2Code getAccessToken(String accessToken) {
        for (String clientId : this.accessTokens.keySet()) {
            List<OAuth2Code> tokens = this.accessTokens.get(clientId);
            for (OAuth2Code token : tokens) {
                if (!token.getValue().equals(accessToken)) continue;
                return token;
            }
        }
        return null;
    }

    @Override
    public void registerAccessToken(String clientId, OAuth2Code accessToken) {
        if (this.accessTokens.containsKey(clientId)) {
            this.accessTokens.get(clientId).add(accessToken);
        } else {
            ArrayList list = Lists.newArrayList();
            list.add(accessToken);
            this.accessTokens.put(clientId, list);
        }
    }

    @Override
    public void unregisterAccessToken(String clientId, String accessToken) {
        if (this.accessTokens.containsKey(clientId)) {
            List<OAuth2Code> tokens = this.accessTokens.get(clientId);
            for (OAuth2Code token : tokens) {
                if (!token.getValue().equals(accessToken)) continue;
                tokens.remove(token);
                return;
            }
        }
        throw new RuntimeException("access token not found");
    }

    @Override
    public OAuth2Code getRefreshToken(String refreshToken) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public void registerRefreshToken(String clientId, OAuth2Code refreshToken) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public void unregisterRefreshToken(String clientId, String refreshToken) {
        throw new RuntimeException("not yet implemented");
    }

    private void loadClientsFromCanonical() {
        for (String clientId : JSONObject.getNames((JSONObject)this.oauthDB)) {
            try {
                OAuth2Code code;
                JSONObject clientJson = this.oauthDB.getJSONObject(clientId).getJSONObject("registration");
                OAuth2Client client = (OAuth2Client)this.converter.convertToObject(clientJson.toString(), OAuth2Client.class);
                client.setType(clientJson.getString("type").equals("public") ? OAuth2Client.ClientType.PUBLIC : OAuth2Client.ClientType.CONFIDENTIAL);
                this.clients.add(client);
                JSONObject clientJS = this.oauthDB.getJSONObject(clientId);
                if (clientJS.has("authorizationCodes")) {
                    JSONObject authCodes = clientJS.getJSONObject("authorizationCodes");
                    for (String authCodeId : JSONObject.getNames((JSONObject)authCodes)) {
                        code = (OAuth2Code)this.converter.convertToObject(authCodes.getJSONObject(authCodeId).toString(), OAuth2Code.class);
                        code.setValue(authCodeId);
                        code.setClient(client);
                        this.registerAuthorizationCode(clientId, code);
                    }
                }
                if (!clientJS.has("accessTokens")) continue;
                JSONObject accessTokens = clientJS.getJSONObject("accessTokens");
                for (String accessTokenId : JSONObject.getNames((JSONObject)accessTokens)) {
                    code = (OAuth2Code)this.converter.convertToObject(accessTokens.getJSONObject(accessTokenId).toString(), OAuth2Code.class);
                    code.setValue(accessTokenId);
                    code.setClient(client);
                    code.setType(OAuth2Types.CodeType.ACCESS_TOKEN);
                    this.registerAccessToken(clientId, code);
                }
            }
            catch (JSONException je) {
                throw new ProtocolException(500, je.getMessage(), (Throwable)je);
            }
        }
    }
}

