/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth2.validators;

import com.google.inject.Inject;
import org.apache.shindig.social.core.oauth2.OAuth2Client;
import org.apache.shindig.social.core.oauth2.OAuth2DataService;
import org.apache.shindig.social.core.oauth2.OAuth2Exception;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedRequest;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedResponse;
import org.apache.shindig.social.core.oauth2.OAuth2Types;
import org.apache.shindig.social.core.oauth2.validators.OAuth2GrantValidator;

public class ClientCredentialsGrantValidator
implements OAuth2GrantValidator {
    private OAuth2DataService service;

    @Inject
    public ClientCredentialsGrantValidator(OAuth2DataService service) {
        this.service = service;
    }

    public void setOAuth2DataService(OAuth2DataService service) {
        this.service = service;
    }

    @Override
    public String getGrantType() {
        return "client_credentials";
    }

    @Override
    public void validateRequest(OAuth2NormalizedRequest req) throws OAuth2Exception {
        OAuth2Client cl = this.service.getClient(req.getClientId());
        if (cl == null || cl.getFlow() != OAuth2Client.Flow.CLIENT_CREDENTIALS) {
            this.throwAccessDenied("Bad client id or password");
        }
        if (cl.getType() != OAuth2Client.ClientType.CONFIDENTIAL) {
            this.throwAccessDenied("Client credentials flow does not support public clients");
        }
        if (!cl.getSecret().equals(req.getClientSecret())) {
            this.throwAccessDenied("Bad client id or password");
        }
    }

    private void throwAccessDenied(String msg) throws OAuth2Exception {
        OAuth2NormalizedResponse resp = new OAuth2NormalizedResponse();
        resp.setError(OAuth2Types.ErrorType.ACCESS_DENIED.toString());
        resp.setErrorDescription(msg);
        resp.setStatus(403);
        throw new OAuth2Exception(resp);
    }
}

