/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.protocol.HandlerPreconditions;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.Service;
import org.apache.shindig.social.opensocial.model.MediaItem;
import org.apache.shindig.social.opensocial.service.SocialRequestItem;
import org.apache.shindig.social.opensocial.spi.CollectionOptionsFactory;
import org.apache.shindig.social.opensocial.spi.MediaItemService;
import org.apache.shindig.social.opensocial.spi.UserId;

@Service(name="mediaItems", path="/{userId}+/{groupId}/{albumId}/{id}+")
public class MediaItemHandler {
    private final MediaItemService service;
    private final ContainerConfig config;
    private final CollectionOptionsFactory collectionOptionsFactory;

    @Inject
    public MediaItemHandler(MediaItemService service, ContainerConfig config, CollectionOptionsFactory collectionOptionsFactory) {
        this.service = service;
        this.config = config;
        this.collectionOptionsFactory = collectionOptionsFactory;
    }

    @Operation(httpMethods={"GET"})
    public Future<?> get(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        ImmutableSet optionalAlbumIds = ImmutableSet.copyOf((Collection)request.getListParameter("albumId"));
        ImmutableSet optionalMediaItemIds = ImmutableSet.copyOf(this.getRequestMediaItemIds(request));
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No user ID specified");
        String albumId = null;
        if (optionalAlbumIds.size() == 1) {
            albumId = (String)Iterables.getOnlyElement((Iterable)optionalAlbumIds);
        } else if (optionalAlbumIds.size() > 1) {
            throw new IllegalArgumentException("Multiple Album IDs not supported");
        }
        if (albumId == null && !optionalMediaItemIds.isEmpty()) {
            throw new IllegalArgumentException("Cannot fetch by MediaItem ID without Album ID");
        }
        if (userIds.size() > 1) {
            if (!optionalMediaItemIds.isEmpty()) {
                throw new IllegalArgumentException("Cannot fetch MediaItem by ID for multiple users");
            }
            if (albumId != null) {
                throw new IllegalArgumentException("Cannot fetch MediaItem by Album for multiple users");
            }
        }
        if (!optionalMediaItemIds.isEmpty()) {
            if (optionalMediaItemIds.size() == 1) {
                return this.service.getMediaItem((UserId)Iterables.getOnlyElement(userIds), request.getAppId(), albumId, (String)Iterables.getOnlyElement((Iterable)optionalMediaItemIds), request.getFields(), request.getToken());
            }
            return this.service.getMediaItems((UserId)Iterables.getOnlyElement(userIds), request.getAppId(), albumId, (Set<String>)optionalMediaItemIds, request.getFields(), this.collectionOptionsFactory.create((RequestItem)request), request.getToken());
        }
        if (albumId != null) {
            return this.service.getMediaItems((UserId)Iterables.getOnlyElement(userIds), request.getAppId(), albumId, (Set<String>)request.getFields(), this.collectionOptionsFactory.create((RequestItem)request), request.getToken());
        }
        return this.service.getMediaItems(userIds, request.getGroup(), request.getAppId(), (Set<String>)request.getFields(), this.collectionOptionsFactory.create((RequestItem)request), request.getToken());
    }

    @Operation(httpMethods={"DELETE"})
    public Future<?> delete(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        ImmutableSet albumIds = ImmutableSet.copyOf((Collection)request.getListParameter("albumId"));
        ImmutableSet mediaItemIds = ImmutableSet.copyOf(this.getRequestMediaItemIds(request));
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular(userIds, (String)"Exactly one user ID must be specified");
        HandlerPreconditions.requireSingular((Collection)albumIds, (String)"Exactly one Album ID must be specified");
        HandlerPreconditions.requireSingular((Collection)mediaItemIds, (String)"Exactly one MediaItem ID must be specified");
        return this.service.deleteMediaItem((UserId)Iterables.getOnlyElement(userIds), request.getAppId(), (String)Iterables.getOnlyElement((Iterable)albumIds), (String)Iterables.getOnlyElement((Iterable)mediaItemIds), request.getToken());
    }

    @Operation(httpMethods={"POST"}, bodyParam="data")
    public Future<?> create(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        ImmutableSet albumIds = ImmutableSet.copyOf((Collection)request.getListParameter("albumId"));
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular(userIds, (String)"Exactly one user ID must be specified");
        HandlerPreconditions.requireSingular((Collection)albumIds, (String)"Exactly one Album ID must be specified");
        return this.service.createMediaItem((UserId)Iterables.getOnlyElement(userIds), request.getAppId(), (String)Iterables.getOnlyElement((Iterable)albumIds), this.getRequestMediaItem(request), request.getToken());
    }

    @Operation(httpMethods={"PUT"}, bodyParam="data")
    public Future<?> update(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        ImmutableSet albumIds = ImmutableSet.copyOf((Collection)request.getListParameter("albumId"));
        ImmutableSet mediaItemIds = ImmutableSet.copyOf(this.getRequestMediaItemIds(request));
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular(userIds, (String)"Exactly one user ID must be specified");
        HandlerPreconditions.requireSingular((Collection)albumIds, (String)"Exactly one Album ID must be specified");
        HandlerPreconditions.requireSingular((Collection)mediaItemIds, (String)"Exactly one MediaItem ID must be specified");
        return this.service.updateMediaItem((UserId)Iterables.getOnlyElement(userIds), request.getAppId(), (String)Iterables.getOnlyElement((Iterable)albumIds), (String)Iterables.getOnlyElement((Iterable)mediaItemIds), this.getRequestMediaItem(request), request.getToken());
    }

    @Operation(httpMethods={"GET"}, path="/@supportedFields")
    public List<Object> supportedFields(RequestItem request) {
        String container = (String)Objects.firstNonNull((Object)request.getToken().getContainer(), (Object)"default");
        return this.config.getList(container, "${Cur['gadgets.features'].opensocial.supportedFields.mediaItem}");
    }

    protected List<String> getRequestMediaItemIds(SocialRequestItem request) {
        List ids = request.getListParameter("id");
        if (ids.isEmpty()) {
            ids = request.getListParameter("mediaItemId");
        }
        return ids;
    }

    protected MediaItem getRequestMediaItem(SocialRequestItem request) {
        MediaItem result = (MediaItem)request.getOptionalTypedParameter("data", MediaItem.class);
        if (result == null) {
            result = (MediaItem)request.getTypedParameter("mediaItem", MediaItem.class);
        }
        return result;
    }
}

