/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.spi;

import com.google.common.base.Objects;
import java.util.regex.Pattern;

public class DomainName {
    private String domainName;
    private static final Pattern domainNamePattern = Pattern.compile("[\\w.-]*");

    public DomainName(String domainName) throws IllegalArgumentException {
        this.setDomainName(domainName);
    }

    private boolean validate(String domainName) {
        return domainNamePattern.matcher(domainName).matches();
    }

    public String getDomainName() {
        return this.domainName;
    }

    public boolean setDomainName(String domainName) throws IllegalArgumentException {
        if (this.validate(domainName)) {
            this.domainName = domainName;
            return true;
        }
        throw new IllegalArgumentException("The provided DomainName is not valid");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DomainName)) {
            return false;
        }
        DomainName actual = (DomainName)o;
        return this.getDomainName().equals(actual.getDomainName());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.domainName});
    }

    public String toString() {
        return this.domainName;
    }
}

