/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.ImmutableMap;
import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import org.apache.shindig.gadgets.GadgetContext;
import org.json.JSONException;
import org.json.JSONObject;

public class GadgetELResolver
extends ELResolver {
    public static final String USER_PREFS_PROPERTY = "UserPrefs";
    public static final String VIEW_PARAMS_PROPERTY = "ViewParams";
    private final GadgetContext gadgetContext;

    public GadgetELResolver(GadgetContext context) {
        this.gadgetContext = context;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return String.class;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base == null) {
            if (VIEW_PARAMS_PROPERTY.equals(property)) {
                context.setPropertyResolved(true);
                return Object.class;
            }
            if (USER_PREFS_PROPERTY.equals(property)) {
                context.setPropertyResolved(true);
                return Map.class;
            }
        }
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null) {
            if (VIEW_PARAMS_PROPERTY.equals(property)) {
                context.setPropertyResolved(true);
                String params = this.gadgetContext.getParameter("view-params");
                if (params != null && !"".equals(params)) {
                    try {
                        return new JSONObject(params);
                    }
                    catch (JSONException e) {
                        throw new ELException((Throwable)e);
                    }
                }
                return ImmutableMap.of();
            }
            if (USER_PREFS_PROPERTY.equals(property)) {
                context.setPropertyResolved(true);
                return this.gadgetContext.getUserPrefs().getPrefs();
            }
        }
        return null;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base == null && (VIEW_PARAMS_PROPERTY.equals(property) || USER_PREFS_PROPERTY.equals(property))) {
            context.setPropertyResolved(true);
        }
        return true;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base == null && (VIEW_PARAMS_PROPERTY.equals(property) || USER_PREFS_PROPERTY.equals(property))) {
            throw new PropertyNotWritableException("Cannot override " + property);
        }
    }
}

