/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.admin;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.gadgets.admin.BasicGadgetAdminStore;
import org.apache.shindig.gadgets.admin.GadgetAdminStore;

public class GadgetAdminModule
extends AbstractModule {
    private static final String GADGET_ADMIN_CONFIG = "config/gadget-admin.json";
    private static final String classname = GadgetAdminModule.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");

    protected void configure() {
        this.bind(GadgetAdminStore.class).toProvider(GadgetAdminStoreProvider.class);
    }

    @Singleton
    public static class GadgetAdminStoreProvider
    implements Provider<GadgetAdminStore> {
        private BasicGadgetAdminStore store;

        @Inject
        public GadgetAdminStoreProvider(BasicGadgetAdminStore store) {
            this.store = store;
            this.loadStore();
        }

        private void loadStore() {
            block2: {
                try {
                    String gadgetAdminString = ResourceLoader.getContent((String)GadgetAdminModule.GADGET_ADMIN_CONFIG);
                    this.store.init(gadgetAdminString);
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(Level.WARNING)) break block2;
                    LOG.logp(Level.WARNING, classname, "loadStore", "failedToInit", new Object[]{GadgetAdminModule.GADGET_ADMIN_CONFIG});
                    LOG.log(Level.WARNING, "", t);
                }
            }
        }

        public GadgetAdminStore get() {
            return this.store;
        }
    }
}

