/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.features;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.common.Pair;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.features.ApiDirective;
import org.apache.shindig.gadgets.features.FeatureFile;
import org.apache.shindig.gadgets.features.FeatureFileSystem;
import org.apache.shindig.gadgets.features.FeatureParser;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.features.FeatureResourceLoader;

@Singleton
public class FeatureRegistry {
    public static final String CACHE_NAME = "FeatureJsCache";
    public static final String RESOURCE_SCHEME = "res";
    public static final String FILE_SCHEME = "file";
    public static final Splitter CRLF_SPLITTER = Splitter.onPattern((String)"[\r\n]+").trimResults().omitEmptyStrings();
    private static final String classname = FeatureRegistry.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private final Cache<String, LookupResult> cache;
    private final FeatureParser parser = new FeatureParser();
    private final FeatureResourceLoader resourceLoader;
    private final ImmutableMap<String, FeatureNode> featureMap;
    private final FeatureFileSystem fileSystem;
    private final String repository;

    @Inject
    public FeatureRegistry(FeatureResourceLoader resourceLoader, CacheProvider cacheProvider, @Named(value="org.apache.shindig.features") List<String> features, FeatureFileSystem fileSystem) throws GadgetException {
        this(resourceLoader, cacheProvider, features, fileSystem, null);
    }

    public FeatureRegistry(FeatureResourceLoader resourceLoader, CacheProvider cacheProvider, @Named(value="org.apache.shindig.features") List<String> features, FeatureFileSystem fileSystem, String repository) throws GadgetException {
        this.resourceLoader = resourceLoader;
        this.fileSystem = fileSystem;
        this.repository = repository;
        this.featureMap = this.register(features);
        this.connectDependencyGraph();
        this.cache = cacheProvider.createCache(CACHE_NAME);
    }

    public String getRepository() {
        return this.repository;
    }

    protected ImmutableMap<String, FeatureNode> register(List<String> resourceList) throws GadgetException {
        HashMap featureMapBuilder = Maps.newHashMap();
        try {
            for (String location : resourceList) {
                Uri uriLoc = FeatureRegistry.getComponentUri(location);
                if (uriLoc.getScheme() != null && uriLoc.getScheme().equals(RESOURCE_SCHEME)) {
                    ArrayList resources = Lists.newArrayList();
                    location = uriLoc.getPath();
                    if (location.startsWith("/")) {
                        location = location.substring(1);
                    }
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.logp(Level.INFO, classname, "register", "loadResourcesFrom", new Object[]{uriLoc.toString()});
                    }
                    if (location.endsWith(".txt")) {
                        for (String resource : CRLF_SPLITTER.split((CharSequence)this.resourceLoader.getResourceContent(location))) {
                            if (resource.charAt(0) == '#') continue;
                            resource = FeatureRegistry.getComponentUri(resource).getPath();
                            resources.add(resource);
                        }
                    } else {
                        resources.add(location);
                    }
                    this.loadResources(resources, featureMapBuilder);
                    continue;
                }
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.logp(Level.INFO, classname, "register", "loadFilesFrom", new Object[]{location});
                }
                this.loadFile(this.fileSystem.getFile(uriLoc.getPath()), featureMapBuilder);
            }
            return ImmutableMap.copyOf((Map)featureMapBuilder);
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PATH, (Throwable)e);
        }
    }

    public LookupResult getFeatureResources(GadgetContext ctx, Collection<String> needed, List<String> unsupported, boolean transitive) {
        LookupResult lookup;
        boolean useCache = transitive && !ctx.getIgnoreCache();
        String cacheKey = this.makeCacheKey(needed, ctx, unsupported);
        if (useCache && (lookup = (LookupResult)this.cache.getElement((Object)cacheKey)) != null) {
            return lookup;
        }
        List<FeatureNode> featureNodes = transitive ? this.getTransitiveDeps(needed, unsupported) : this.getRequestedNodes(needed, unsupported);
        ImmutableList.Builder bundlesBuilder = new ImmutableList.Builder();
        for (FeatureNode entry : featureNodes) {
            boolean specificContainerMatched = false;
            LinkedList noContainerBundles = Lists.newLinkedList();
            for (FeatureBundle bundle : entry.getBundles(ctx.getRenderingContext())) {
                String containerAttrib = bundle.getAttribs().get("container");
                if (containerAttrib != null) {
                    if (!this.containerMatch(containerAttrib, ctx.getContainer())) continue;
                    bundlesBuilder.add((Object)bundle);
                    specificContainerMatched = true;
                    continue;
                }
                noContainerBundles.add(bundle);
            }
            if (specificContainerMatched) continue;
            for (FeatureBundle bundle : noContainerBundles) {
                bundlesBuilder.add((Object)bundle);
            }
        }
        LookupResult result = new LookupResult((List<FeatureBundle>)bundlesBuilder.build());
        if (useCache && (unsupported == null || unsupported.isEmpty())) {
            this.cache.addElement((Object)cacheKey, (Object)result);
        }
        return result;
    }

    public LookupResult getFeatureResources(GadgetContext ctx, Collection<String> needed, List<String> unsupported) {
        return this.getFeatureResources(ctx, needed, unsupported, true);
    }

    public LookupResult getAllFeatures() {
        return this.getFeatureResources(new GadgetContext(), (Collection<String>)this.featureMap.keySet(), null);
    }

    public List<String> getFeatures(Collection<String> needed) {
        List<FeatureNode> fullTree = this.getTransitiveDeps(needed, Lists.newLinkedList());
        LinkedList allFeatures = Lists.newLinkedList();
        for (FeatureNode node : fullTree) {
            allFeatures.add(node.name);
        }
        return allFeatures;
    }

    public Set<String> getAllFeatureNames() {
        return this.featureMap.keySet();
    }

    static Uri getComponentUri(String str) {
        return str.startsWith("res://") ? new UriBuilder().setScheme(RESOURCE_SCHEME).setPath(str.substring(6)).toUri() : Uri.parse((String)str);
    }

    private List<FeatureNode> getTransitiveDeps(Collection<String> needed, List<String> unsupported) {
        final List<FeatureNode> requested = this.getRequestedNodes(needed, unsupported);
        Comparator<FeatureNode> nodeDepthComparator = new Comparator<FeatureNode>(){

            @Override
            public int compare(FeatureNode one, FeatureNode two) {
                if (one.nodeDepth > two.nodeDepth || one.nodeDepth == two.nodeDepth && requested.indexOf(one) < requested.indexOf(two)) {
                    return -1;
                }
                return 1;
            }
        };
        Collections.sort(requested, nodeDepthComparator);
        HashSet alreadySeen = Sets.newHashSet();
        LinkedList fullDeps = Lists.newLinkedList();
        for (FeatureNode requestedFeature : requested) {
            for (FeatureNode toAdd : requestedFeature.getTransitiveDeps()) {
                if (alreadySeen.contains(toAdd.name)) continue;
                alreadySeen.add(toAdd.name);
                fullDeps.add(toAdd);
            }
        }
        return fullDeps;
    }

    private List<FeatureNode> getRequestedNodes(Collection<String> needed, List<String> unsupported) {
        ArrayList requested = Lists.newArrayList();
        for (String featureName : needed) {
            if (this.featureMap.containsKey((Object)featureName)) {
                requested.add(this.featureMap.get((Object)featureName));
                continue;
            }
            if (unsupported == null) continue;
            unsupported.add(featureName);
        }
        return requested;
    }

    private boolean containerMatch(String containerAttrib, String container) {
        for (String attr : Splitter.on((char)',').trimResults().split((CharSequence)containerAttrib)) {
            if (!attr.equals(container)) continue;
            return true;
        }
        return false;
    }

    private void connectDependencyGraph() throws GadgetException {
        LinkedList problems = Lists.newLinkedList();
        LinkedList theFeatures = Lists.newLinkedList();
        for (Map.Entry featureEntry : this.featureMap.entrySet()) {
            String name = (String)featureEntry.getKey();
            FeatureNode feature = (FeatureNode)featureEntry.getValue();
            for (String rawDep : feature.getRawDeps()) {
                if (!this.featureMap.containsKey((Object)rawDep)) {
                    problems.add("Feature [" + name + "] has dependency on unknown feature: " + rawDep);
                    continue;
                }
                feature.addDep((FeatureNode)this.featureMap.get((Object)rawDep));
                theFeatures.add(feature);
            }
        }
        for (FeatureNode feature : theFeatures) {
            try {
                feature.completeNodeGraph();
            }
            catch (GadgetException e) {
                problems.add(e.getMessage());
            }
        }
        if (!problems.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Problems found processing features:\n");
            Joiner.on((char)'\n').appendTo(sb, (Iterable)problems);
            throw new GadgetException(GadgetException.Code.INVALID_CONFIG, sb.toString());
        }
    }

    private void loadResources(List<String> resources, Map<String, FeatureNode> featureMapBuilder) throws GadgetException {
        try {
            for (String resource : resources) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Processing resource: " + resource);
                }
                String content = this.resourceLoader.getResourceContent(resource);
                Uri parent = new UriBuilder().setScheme(RESOURCE_SCHEME).setPath(resource).toUri();
                this.loadFeature(parent, content, featureMapBuilder);
            }
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PATH, (Throwable)e);
        }
    }

    private void loadFile(FeatureFile file, Map<String, FeatureNode> featureMapBuilder) throws GadgetException, IOException {
        FeatureFile[] toLoad;
        FeatureFile[] featureFileArray;
        if (!file.exists() || !file.canRead()) {
            throw new GadgetException(GadgetException.Code.INVALID_CONFIG, "Feature file '" + file.getPath() + "' doesn't exist or can't be read");
        }
        if (file.isDirectory()) {
            featureFileArray = file.listFiles();
        } else {
            FeatureFile[] featureFileArray2 = new FeatureFile[1];
            featureFileArray = featureFileArray2;
            featureFileArray2[0] = file;
        }
        for (FeatureFile featureFile : toLoad = featureFileArray) {
            if (featureFile.isDirectory()) {
                this.loadFile(featureFile, featureMapBuilder);
                continue;
            }
            if (featureFile.getName().toLowerCase(Locale.ENGLISH).endsWith(".xml")) {
                String content = featureFile.getContent();
                Uri parent = Uri.fromJavaUri((URI)featureFile.toURI());
                this.loadFeature(parent, content, featureMapBuilder);
                continue;
            }
            if (!LOG.isLoggable(Level.FINEST)) continue;
            LOG.finest(featureFile.getAbsolutePath() + " doesn't seem to be an XML file.");
        }
    }

    protected void loadFeature(Uri parent, String xml, Map<String, FeatureNode> featureMapBuilder) throws GadgetException {
        FeatureParser.ParsedFeature parsed = this.parser.parse(parent, xml);
        if (featureMapBuilder.containsKey(parsed.getName()) && LOG.isLoggable(Level.WARNING)) {
            LOG.logp(Level.WARNING, classname, "doFilter", "overridingFeature", new Object[]{parsed.getName(), parent});
        }
        ArrayList bundles = Lists.newArrayList();
        for (FeatureParser.ParsedFeature.Bundle parsedBundle : parsed.getBundles()) {
            ArrayList resources = Lists.newArrayList();
            for (FeatureParser.ParsedFeature.Resource parsedResource : parsedBundle.getResources()) {
                if (parsedResource.getSource() == null) {
                    resources.add(new InlineFeatureResource(parsed.getName() + ":inline.js", parsedResource.getContent(), parsedResource.getAttribs()));
                    continue;
                }
                resources.add(this.resourceLoader.load(parsedResource.getSource(), this.getResourceAttribs(parsedBundle.getAttribs(), parsedResource.getAttribs())));
            }
            bundles.add(new FeatureBundle(parsedBundle, resources));
        }
        featureMapBuilder.put(parsed.getName(), new FeatureNode(parsed.getName(), bundles, parsed.getDeps()));
    }

    protected String makeCacheKey(Collection<String> needed, GadgetContext ctx, List<String> unsupported) {
        ArrayList neededList = Lists.newArrayList(needed);
        Collections.sort(neededList);
        return StringUtils.join((Iterable)neededList, (String)":") + '|' + (Object)((Object)ctx.getRenderingContext()) + '|' + ctx.getContainer() + '|' + (unsupported != null) + '|' + Strings.nullToEmpty((String)this.repository);
    }

    private Map<String, String> getResourceAttribs(Map<String, String> bundleAttribs, Map<String, String> resourceAttribs) {
        return ImmutableMap.builder().putAll(bundleAttribs).putAll(resourceAttribs).build();
    }

    private static final class FeatureNode {
        private final String name;
        private final List<FeatureBundle> bundles;
        private final List<String> requestedDeps;
        private final List<FeatureNode> depList;
        private List<FeatureNode> transitiveDeps;
        private boolean calculatedDepsStale;
        private int nodeDepth = 0;

        private FeatureNode(String name, List<FeatureBundle> bundles, List<String> rawDeps) {
            this.name = name;
            this.bundles = ImmutableList.copyOf(bundles);
            this.requestedDeps = ImmutableList.copyOf(rawDeps);
            this.depList = Lists.newLinkedList();
            this.transitiveDeps = Lists.newArrayList((Object[])new FeatureNode[]{this});
            this.calculatedDepsStale = false;
        }

        public Iterable<FeatureBundle> getBundles(RenderingContext rctx) {
            String tagMatch = null;
            String directTag = rctx.getFeatureBundleTag();
            for (FeatureBundle bundle : this.bundles) {
                if (directTag == null || !directTag.equalsIgnoreCase(bundle.getType())) continue;
                tagMatch = directTag;
            }
            if (tagMatch == null) {
                tagMatch = RenderingContext.ALL.getFeatureBundleTag();
            }
            final String useForMatching = tagMatch;
            return new Iterable<FeatureBundle>(){

                @Override
                public Iterator<FeatureBundle> iterator() {
                    return new Iterator<FeatureBundle>(){
                        private FeatureBundle next;
                        private final Iterator<FeatureBundle> it;
                        {
                            this.it = FeatureNode.this.bundles.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            while (this.next == null && this.it.hasNext()) {
                                FeatureBundle candidate = this.it.next();
                                if (!useForMatching.equalsIgnoreCase(candidate.getType())) continue;
                                this.next = candidate;
                            }
                            return this.next != null;
                        }

                        @Override
                        public FeatureBundle next() {
                            this.hasNext();
                            FeatureBundle ret = this.next;
                            this.next = null;
                            return ret;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("Can't remove from bundle iterator");
                        }
                    };
                }
            };
        }

        public List<String> getRawDeps() {
            return this.requestedDeps;
        }

        public void addDep(FeatureNode dep) {
            this.depList.add(dep);
            this.calculatedDepsStale = true;
        }

        private List<FeatureNode> getDepList() {
            ArrayList revOrderDeps = Lists.newArrayList(this.depList);
            Collections.reverse(revOrderDeps);
            return ImmutableList.copyOf((Collection)revOrderDeps);
        }

        public void completeNodeGraph() throws GadgetException {
            if (!this.calculatedDepsStale) {
                return;
            }
            HashSet<String> tempList = new HashSet<String>();
            this.checkDependencyLoop(this, tempList);
            this.nodeDepth = 0;
            this.transitiveDeps = Lists.newLinkedList();
            this.transitiveDeps.add(this);
            LinkedList toTraverse = Lists.newLinkedList();
            toTraverse.add(Pair.of((Object)this, (Object)Pair.of((Object)0, (Object)"")));
            while (!toTraverse.isEmpty()) {
                Pair next = (Pair)toTraverse.poll();
                String debug = (String)((Pair)next.two).two + ((Integer)((Pair)next.two).one > 0 ? " -> " : "") + ((FeatureNode)next.one).name;
                this.transitiveDeps.add((FeatureNode)next.one);
                this.nodeDepth = Math.max(this.nodeDepth, (Integer)((Pair)next.two).one);
                for (FeatureNode nextDep : ((FeatureNode)next.one).getDepList()) {
                    toTraverse.add(Pair.of((Object)nextDep, (Object)Pair.of((Object)((Integer)((Pair)next.two).one + 1), (Object)debug)));
                }
            }
            Collections.reverse(this.transitiveDeps);
            this.calculatedDepsStale = false;
        }

        public List<FeatureNode> getTransitiveDeps() {
            return this.transitiveDeps;
        }

        private void checkDependencyLoop(FeatureNode featureNode, Set<String> dependencyList) throws GadgetException {
            String featureNodeName = featureNode.name;
            if (dependencyList.contains(featureNodeName)) {
                throw new GadgetException(GadgetException.Code.INVALID_CONFIG, "Feature " + featureNodeName + " has dependency loop problem.");
            }
            dependencyList.add(featureNodeName);
            List<FeatureNode> deps = featureNode.getDepList();
            for (FeatureNode f : deps) {
                this.checkDependencyLoop(f, dependencyList);
                dependencyList.remove(f.name);
            }
        }
    }

    public static class FeatureBundle {
        private final FeatureParser.ParsedFeature.Bundle bundle;
        private final List<FeatureResource> resources;

        public FeatureBundle(FeatureParser.ParsedFeature.Bundle bundle, List<FeatureResource> resources) {
            this.bundle = bundle;
            this.resources = ImmutableList.copyOf(resources);
        }

        public String getName() {
            return this.bundle.getName();
        }

        public String getType() {
            return this.bundle.getType();
        }

        public Map<String, String> getAttribs() {
            return this.bundle.getAttribs();
        }

        public List<FeatureResource> getResources() {
            return this.resources;
        }

        public List<ApiDirective> getApis() {
            return this.bundle.getApis();
        }

        public boolean isSupportDefer() {
            return this.bundle.isSupportDefer();
        }

        public List<String> getApis(ApiDirective.Type type, boolean isExports) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ApiDirective api : this.bundle.getApis()) {
                if (api.getType() != type || api.isExports() != isExports) continue;
                builder.add((Object)api.getValue());
            }
            return builder.build();
        }
    }

    public static class LookupResult {
        private final List<FeatureBundle> bundles;
        private final List<FeatureResource> allResources;

        public LookupResult(List<FeatureBundle> bundles) {
            this.bundles = bundles;
            ImmutableList.Builder resourcesBuilder = ImmutableList.builder();
            for (FeatureBundle bundle : this.getBundles()) {
                resourcesBuilder.addAll(bundle.getResources());
            }
            this.allResources = resourcesBuilder.build();
        }

        public List<FeatureBundle> getBundles() {
            return this.bundles;
        }

        public List<FeatureResource> getResources() {
            return this.allResources;
        }
    }

    private static final class InlineFeatureResource
    extends FeatureResource.Attribute {
        private final String name;
        private final String content;

        private InlineFeatureResource(String name, String content, Map<String, String> attribs) {
            super(attribs);
            this.content = content;
            this.name = name;
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public String getDebugContent() {
            return this.content;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

