/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.common.util.DateUtil;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.AbstractHttpCache;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class HttpResponseBuilder
extends MutableContent {
    private int httpStatusCode = 200;
    private final Multimap<String, String> headers = HttpResponse.newHeaderMultimap();
    private final Map<String, String> metadata = Maps.newHashMap();
    private HttpResponse responseObj;
    private int responseObjNumChanges;
    private long refetchStrictNoCacheAfterMs = AbstractHttpCache.REFETCH_STRICT_NO_CACHE_AFTER_MS_DEFAULT;
    private final List<String> NO_CACHE_HEADER = ImmutableList.of((Object)"no-cache");

    public HttpResponseBuilder(GadgetHtmlParser parser, HttpResponse response) {
        super(parser, response);
        if (response != null) {
            this.httpStatusCode = response.getHttpStatusCode();
            this.headers.putAll(response.getHeaders());
            this.metadata.putAll(response.getMetadata());
            this.refetchStrictNoCacheAfterMs = response.getRefetchStrictNoCacheAfterMs();
        } else {
            this.setResponse(null);
        }
        this.responseObj = response;
        this.responseObjNumChanges = this.getNumChanges();
    }

    public HttpResponseBuilder() {
        this(HttpResponseBuilder.unsupportedParser(), (HttpResponse)null);
    }

    public HttpResponseBuilder(HttpResponseBuilder builder) {
        this(HttpResponseBuilder.unsupportedParser(), builder.create());
    }

    public HttpResponseBuilder(HttpResponse response) {
        this(HttpResponseBuilder.unsupportedParser(), response);
    }

    public HttpResponse create() {
        if (this.getNumChanges() != this.responseObjNumChanges || this.responseObj == null) {
            this.responseObj = new HttpResponse(this);
            this.responseObjNumChanges = this.getNumChanges();
        }
        return this.responseObj;
    }

    public HttpResponseBuilder setResponseString(String body) {
        this.setContentBytes(CharsetUtil.getUtf8Bytes((String)body), Charsets.UTF_8);
        return this;
    }

    public HttpResponseBuilder setEncoding(Charset charset) {
        Collection values = this.headers.get((Object)"Content-Type");
        if (!values.isEmpty()) {
            String[] parts;
            String contentType = (String)values.iterator().next();
            StringBuilder newContentTypeBuilder = new StringBuilder("");
            for (String part : parts = StringUtils.split((String)contentType, (char)';')) {
                if (part.contains("charset=")) continue;
                if (newContentTypeBuilder.length() > 0) {
                    newContentTypeBuilder.append("; ");
                }
                newContentTypeBuilder.append(part);
            }
            if (charset != null) {
                if (newContentTypeBuilder.length() > 0) {
                    newContentTypeBuilder.append("; ");
                }
                newContentTypeBuilder.append("charset=").append(charset.name());
            }
            values.clear();
            String newContentType = newContentTypeBuilder.toString();
            values.add(newContentType);
            if (values.size() != 1 || contentType.equals(newContentType)) {
                this.incrementNumChanges();
            }
        }
        return this;
    }

    public HttpResponseBuilder setResponse(byte[] responseBytes) {
        if (responseBytes == null) {
            responseBytes = ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        byte[] newBytes = new byte[responseBytes.length];
        System.arraycopy(responseBytes, 0, newBytes, 0, responseBytes.length);
        this.setContentBytes(newBytes);
        return this;
    }

    public HttpResponseBuilder setResponseNoCopy(byte[] responseBytes) {
        if (responseBytes == null) {
            responseBytes = ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        this.setContentBytes(responseBytes);
        return this;
    }

    public HttpResponseBuilder setHttpStatusCode(int httpStatusCode) {
        if (this.httpStatusCode != httpStatusCode) {
            this.httpStatusCode = httpStatusCode;
            this.incrementNumChanges();
        }
        return this;
    }

    public HttpResponseBuilder clearAllHeaders() {
        this.incrementNumChanges();
        this.headers.clear();
        return this;
    }

    public HttpResponseBuilder addHeader(String name, String value) {
        if (name != null) {
            this.headers.put((Object)name, (Object)value);
            this.incrementNumChanges();
        }
        return this;
    }

    public HttpResponseBuilder setHeader(String name, String value) {
        if (name != null) {
            this.headers.replaceValues((Object)name, (Iterable)Lists.newArrayList((Object[])new String[]{value}));
            this.incrementNumChanges();
        }
        return this;
    }

    public String getHeader(String name) {
        if (name != null && this.headers.containsKey((Object)name)) {
            return (String)this.headers.get((Object)name).iterator().next();
        }
        return null;
    }

    public HttpResponseBuilder addHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.headers.put((Object)entry.getKey(), (Object)entry.getValue());
            this.incrementNumChanges();
        }
        return this;
    }

    public HttpResponseBuilder addAllHeaders(Map<String, ? extends List<String>> headers) {
        for (Map.Entry<String, ? extends List<String>> entry : headers.entrySet()) {
            this.headers.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
            this.incrementNumChanges();
        }
        return this;
    }

    public HttpResponseBuilder addAllHeaders(Multimap<String, String> headers) {
        this.headers.putAll(headers);
        this.incrementNumChanges();
        return this;
    }

    public Collection<String> removeHeader(String name) {
        Collection ret = this.headers.removeAll((Object)name);
        if (ret != null) {
            this.incrementNumChanges();
        }
        return ret;
    }

    public HttpResponseBuilder setCacheTtl(int cacheTtl) {
        this.headers.removeAll((Object)"Pragma");
        this.headers.removeAll((Object)"Expires");
        this.headers.replaceValues((Object)"Cache-Control", (Iterable)ImmutableList.of((Object)("public,max-age=" + cacheTtl)));
        this.incrementNumChanges();
        return this;
    }

    public HttpResponseBuilder setExpirationTime(long expirationTime) {
        this.headers.removeAll((Object)"Cache-Control");
        this.headers.removeAll((Object)"Pragma");
        this.headers.put((Object)"Expires", (Object)DateUtil.formatRfc1123Date((long)expirationTime));
        this.incrementNumChanges();
        return this;
    }

    public HttpResponseBuilder setRefetchStrictNoCacheAfterMs(long refetchStrictNoCacheAfterMs) {
        this.refetchStrictNoCacheAfterMs = refetchStrictNoCacheAfterMs;
        this.incrementNumChanges();
        return this;
    }

    public HttpResponseBuilder setCacheControlMaxAge(long expirationTime) {
        String cacheControl = this.getHeader("Cache-Control");
        ArrayList directives = Lists.newArrayList();
        if (cacheControl != null) {
            for (String directive : StringUtils.split((String)cacheControl, (char)',')) {
                if ((directive = directive.trim()).startsWith("max-age") && StringUtils.split((String)directive, (char)'=').length == 2) continue;
                directives.add(directive);
            }
        }
        directives.add("max-age=" + expirationTime);
        this.setHeader("Cache-Control", StringUtils.join((Iterable)directives, (char)','));
        this.incrementNumChanges();
        return this;
    }

    public HttpResponseBuilder setStrictNoCache() {
        this.headers.replaceValues((Object)"Cache-Control", this.NO_CACHE_HEADER);
        this.headers.replaceValues((Object)"Pragma", this.NO_CACHE_HEADER);
        this.headers.removeAll((Object)"Expires");
        this.incrementNumChanges();
        return this;
    }

    public HttpResponseBuilder setMetadata(String key, String value) {
        this.metadata.put(key, value);
        this.incrementNumChanges();
        return this;
    }

    public HttpResponseBuilder setMetadata(Map<String, String> metadata) {
        this.metadata.putAll(metadata);
        this.incrementNumChanges();
        return this;
    }

    public int getContentLength() {
        return this.getResponse().length;
    }

    Multimap<String, String> getHeaders() {
        return this.headers;
    }

    Map<String, String> getMetadata() {
        return this.metadata;
    }

    byte[] getResponse() {
        return this.getRawContentBytes();
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public long getRefetchStrictNoCacheAfterMs() {
        return this.refetchStrictNoCacheAfterMs;
    }

    @Override
    protected void setContentBytesState(byte[] newBytes, Charset newEncoding) {
        super.setContentBytesState(newBytes, newEncoding);
        if (newEncoding != null) {
            this.setEncoding(newEncoding);
        }
    }

    private static GadgetHtmlParser unsupportedParser() {
        return new GadgetHtmlParser(null){

            @Override
            protected Document parseDomImpl(String source) throws GadgetException {
                throw new UnsupportedOperationException("Using HttpResponseBuilder in non-rewriting context");
            }

            @Override
            protected DocumentFragment parseFragmentImpl(String source) throws GadgetException {
                throw new UnsupportedOperationException("Using HttpResponseBuilder in non-rewriting context");
            }
        };
    }
}

