/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.js.JsContent;
import org.apache.shindig.gadgets.js.JsProcessor;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsResponseBuilder;
import org.apache.shindig.gadgets.uri.UriCommon;

public class CajaJsSubtractingProcessor
implements JsProcessor {
    @VisibleForTesting
    static final String ATTRIB_VALUE = "1";

    @Override
    public boolean process(JsRequest jsRequest, JsResponseBuilder builder) {
        if (!jsRequest.getJsUri().cajoleContent()) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (JsContent js : builder.build().getAllJsContent()) {
                if (this.isCajole(js)) continue;
                listBuilder.add((Object)js);
            }
            builder.clearJs().appendAllJs((Iterable<JsContent>)listBuilder.build());
        }
        return true;
    }

    private boolean isCajole(JsContent js) {
        Map<String, String> attribs;
        FeatureResource resource = js.getFeatureResource();
        if (resource != null && (attribs = resource.getAttribs()) != null) {
            String attrib = attribs.get(UriCommon.Param.CAJOLE.getKey());
            return ATTRIB_VALUE.equals(attrib);
        }
        return false;
    }
}

