/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.apache.shindig.gadgets.js.JsException;
import org.apache.shindig.gadgets.js.JsProcessor;
import org.apache.shindig.gadgets.js.JsProcessorRegistry;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsResponseBuilder;

public class DefaultJsProcessorRegistry
implements JsProcessorRegistry {
    private final List<JsProcessor> preProcessors;
    private final List<JsProcessor> optionalProcessors;
    private final List<JsProcessor> requiredProcessors;

    @Inject
    public DefaultJsProcessorRegistry(@Named(value="shindig.js.pre-processors") List<JsProcessor> preProcessors, @Named(value="shindig.js.optional-processors") List<JsProcessor> optionalProcessors, @Named(value="shindig.js.required-processors") List<JsProcessor> requiredProcessors) {
        this.preProcessors = preProcessors;
        this.optionalProcessors = optionalProcessors;
        this.requiredProcessors = requiredProcessors;
    }

    @Override
    public void process(JsRequest request, JsResponseBuilder response) throws JsException {
        for (JsProcessor processor : this.preProcessors) {
            if (processor.process(request, response)) continue;
            return;
        }
        for (JsProcessor processor : this.optionalProcessors) {
            if (!processor.process(request, response)) break;
        }
        for (JsProcessor processor : this.requiredProcessors) {
            processor.process(request, response);
        }
    }
}

