/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.shindig.gadgets.js.JsContent;
import org.apache.shindig.gadgets.js.JsResponse;

public class JsResponseBuilder {
    private static final String EXTERN_DELIM = ";\n";
    private List<JsContent> jsCode = Lists.newLinkedList();
    private final List<String> errors = Lists.newLinkedList();
    private int statusCode = 200;
    private int cacheTtlSecs = 0;
    private boolean proxyCacheable = false;
    private final StringBuilder rawExterns = new StringBuilder();
    private final List<String> externs = Lists.newLinkedList();

    public JsResponseBuilder() {
    }

    public JsResponseBuilder(JsResponse response) {
        this();
        if (response.getAllJsContent() != null) {
            this.jsCode.addAll(Lists.newArrayList(response.getAllJsContent()));
        }
        if (response.getErrors() != null) {
            this.errors.addAll(Lists.newArrayList(response.getErrors()));
        }
        if (response.getExterns() != null) {
            this.rawExterns.append(response.getExterns());
        }
        this.statusCode = response.getStatusCode();
        this.cacheTtlSecs = response.getCacheTtlSecs();
        this.proxyCacheable = response.isProxyCacheable();
    }

    public JsResponseBuilder prependJs(JsContent jsContent) {
        if (this.canAddContent(jsContent)) {
            this.jsCode.add(0, jsContent);
        }
        return this;
    }

    public JsResponseBuilder prependJs(String content, String name) {
        return this.prependJs(JsContent.fromText(content, name));
    }

    public JsResponseBuilder prependJs(String content, String name, boolean noCompile) {
        return this.prependJs(JsContent.fromText(content, name, noCompile));
    }

    public JsResponseBuilder insertJsAt(int index, JsContent jsContent) {
        if (this.canAddContent(jsContent)) {
            this.jsCode.add(index, jsContent);
        }
        return this;
    }

    public JsResponseBuilder appendJs(JsContent jsContent) {
        if (this.canAddContent(jsContent)) {
            this.jsCode.add(jsContent);
        }
        return this;
    }

    public JsResponseBuilder appendJs(String content, String name) {
        return this.appendJs(JsContent.fromText(content, name));
    }

    public JsResponseBuilder appendJs(String content, String name, boolean noCompile) {
        return this.appendJs(JsContent.fromText(content, name, noCompile));
    }

    public JsResponseBuilder appendAllJs(Iterable<JsContent> jsBundle) {
        for (JsContent content : jsBundle) {
            this.appendJs(content);
        }
        return this;
    }

    public JsResponseBuilder clearJs() {
        this.jsCode = Lists.newLinkedList();
        return this;
    }

    public JsResponseBuilder setStatusCode(int responseCode) {
        this.statusCode = responseCode;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public JsResponseBuilder addError(String error) {
        this.errors.add(error);
        return this;
    }

    public JsResponseBuilder addErrors(List<String> errs) {
        this.errors.addAll(errs);
        return this;
    }

    public JsResponseBuilder setCacheTtlSecs(int cacheTtlSecs) {
        this.cacheTtlSecs = cacheTtlSecs;
        return this;
    }

    public int getCacheTtlSecs() {
        return this.cacheTtlSecs;
    }

    public JsResponseBuilder setProxyCacheable(boolean proxyCacheable) {
        this.proxyCacheable = proxyCacheable;
        return this;
    }

    public boolean isProxyCacheable() {
        return this.proxyCacheable;
    }

    public JsResponseBuilder appendRawExtern(String rawExtern) {
        this.rawExterns.append(rawExtern).append(EXTERN_DELIM);
        return this;
    }

    public JsResponseBuilder appendExtern(String extern) {
        this.externs.add(extern);
        return this;
    }

    public JsResponseBuilder appendExterns(List<String> externs) {
        for (String extern : externs) {
            this.appendExtern(extern);
        }
        return this;
    }

    public JsResponseBuilder clearExterns() {
        int last = this.rawExterns.length();
        this.rawExterns.delete(0, last);
        this.externs.clear();
        return this;
    }

    public JsResponse build() {
        return new JsResponse(this.jsCode, this.statusCode, this.cacheTtlSecs, this.proxyCacheable, this.errors, this.rawExterns + this.buildExternString());
    }

    private String buildExternString() {
        StringBuilder builder = new StringBuilder();
        HashSet set = Sets.newHashSet();
        for (String ext : this.externs) {
            List<String> expandedList = this.expand(ext);
            for (String exp : expandedList) {
                if (set.contains(exp) || exp.endsWith(".prototype")) continue;
                if (!exp.contains(".")) {
                    builder.append("var ");
                }
                builder.append(exp).append(" = {}").append(EXTERN_DELIM);
                set.add(exp);
            }
        }
        return builder.toString();
    }

    private List<String> expand(String value) {
        ArrayList result = Lists.newArrayList();
        StringBuilder cur = new StringBuilder();
        for (String part : Splitter.on((char)'.').split((CharSequence)value)) {
            cur.append(cur.length() > 0 ? "." : "").append(part);
            result.add(cur.toString());
        }
        return result;
    }

    private boolean canAddContent(JsContent jsContent) {
        return jsContent.get().length() > 0;
    }
}

