/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.common.base.Preconditions;
import org.apache.shindig.gadgets.oauth.OAuthError;

public class OAuthRequestException
extends Exception {
    private String error;
    private String errorText;

    public OAuthRequestException(OAuthError error) {
        this(error.name(), error.toString());
    }

    public OAuthRequestException(OAuthError error, String errorText) {
        this(error.name(), String.format(error.toString(), errorText));
    }

    public OAuthRequestException(OAuthError error, String errorText, Throwable cause) {
        this(error.name(), String.format(error.toString(), errorText), cause);
    }

    public OAuthRequestException(String error, String errorText) {
        super('[' + error + ',' + errorText + ']');
        this.error = (String)Preconditions.checkNotNull((Object)error);
        this.errorText = (String)Preconditions.checkNotNull((Object)errorText);
    }

    public OAuthRequestException(String error, String errorText, Throwable cause) {
        super('[' + error + ',' + errorText + ']', cause);
        this.error = (String)Preconditions.checkNotNull((Object)error);
        this.errorText = (String)Preconditions.checkNotNull((Object)errorText);
    }

    public OAuthRequestException(String message) {
        super(message);
    }

    public OAuthRequestException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getError() {
        return this.error;
    }

    public String getErrorText() {
        return this.errorText;
    }

    @Override
    public String getMessage() {
        return this.errorText;
    }

    @Override
    public String toString() {
        return '[' + this.error + ',' + this.errorText + ']';
    }
}

