/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2;

import com.google.common.collect.Maps;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.oauth2.OAuth2Error;
import org.apache.shindig.gadgets.oauth2.OAuth2Message;
import org.apache.shindig.gadgets.oauth2.logger.FilteredLogger;
import org.json.JSONException;
import org.json.JSONObject;

public class BasicOAuth2Message
implements OAuth2Message {
    private static final String LOG_CLASS = BasicOAuth2Message.class.getName();
    private static final FilteredLogger LOG = FilteredLogger.getFilteredLogger(LOG_CLASS);
    private OAuth2Error error;
    private final Map<String, String> params = Maps.newHashMapWithExpectedSize((int)5);
    private final Map<String, String> unparsedProperties = Maps.newHashMapWithExpectedSize((int)0);

    @Override
    public String getAccessToken() {
        return this.params.get("access_token");
    }

    @Override
    public String getAuthorization() {
        return this.params.get("code");
    }

    @Override
    public OAuth2Error getError() {
        String errorParam;
        if (this.error == null && (errorParam = this.params.get("error")) != null) {
            this.error = "invalid_request".equalsIgnoreCase(errorParam) ? OAuth2Error.SPEC_INVALID_REQUEST : ("authorized_client".equalsIgnoreCase(errorParam) ? OAuth2Error.SPEC_UNAUTHORIZED_CLIENT : ("access_denied".equalsIgnoreCase(errorParam) ? OAuth2Error.SPEC_ACCESS_DENIED : ("unsupported_response_type".equalsIgnoreCase(errorParam) ? OAuth2Error.SPEC_UNSUPPORTED_RESPONSE_TYPE : ("invalid_scope".equalsIgnoreCase(errorParam) ? OAuth2Error.SPEC_INVALID_SCOPE : ("server_error".equalsIgnoreCase(errorParam) ? OAuth2Error.SPEC_SERVER_ERROR : ("temporarily_unavailable".equalsIgnoreCase(errorParam) ? OAuth2Error.SPEC_TEMPORARILY_UNAVAILABLE : ("invalid_client".equalsIgnoreCase(errorParam) ? OAuth2Error.SPEC_INVALID_CLIENT : ("invalid_grant".equalsIgnoreCase(errorParam) ? OAuth2Error.SPEC_INVALID_GRANT : ("unsupported_grant_type".equalsIgnoreCase(errorParam) ? OAuth2Error.SPEC_UNSUPPORTED_GRANT_TYPE : OAuth2Error.UNKNOWN_PROBLEM)))))))));
        }
        return this.error;
    }

    @Override
    public String getErrorDescription() {
        return this.params.get("error_description");
    }

    @Override
    public String getErrorUri() {
        return this.params.get("error_uri");
    }

    @Override
    public String getExpiresIn() {
        return this.params.get("expires_in");
    }

    @Override
    public String getMacAlgorithm() {
        return this.params.get("algorithm");
    }

    @Override
    public String getMacSecret() {
        return this.params.get("secret");
    }

    @Override
    public Map<String, String> getParameters() {
        return this.params;
    }

    @Override
    public String getRefreshToken() {
        return this.params.get("refresh_token");
    }

    @Override
    public String getState() {
        return this.params.get("state");
    }

    @Override
    public String getTokenType() {
        return this.params.get("token_type");
    }

    @Override
    public Map<String, String> getUnparsedProperties() {
        return this.unparsedProperties;
    }

    @Override
    public void parseFragment(String fragment) {
        Uri uri = Uri.parse((String)fragment);
        Map _params = uri.getFragmentParameters();
        for (Map.Entry entry : _params.entrySet()) {
            this.params.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
    }

    @Override
    public void parseJSON(String response) {
        try {
            String errorUri;
            String errorDescription;
            String _error;
            String refreshToken;
            String expiresIn;
            String tokenType;
            JSONObject jsonObject = new JSONObject(response);
            String accessToken = jsonObject.optString("access_token", null);
            if (accessToken != null) {
                this.params.put("access_token", accessToken);
            }
            if ((tokenType = jsonObject.optString("token_type", null)) != null) {
                this.params.put("token_type", tokenType);
            }
            if ((expiresIn = jsonObject.optString("expires_in", null)) != null) {
                this.params.put("expires_in", expiresIn);
            }
            if ((refreshToken = jsonObject.optString("refresh_token", null)) != null) {
                this.params.put("refresh_token", refreshToken);
            }
            if ((_error = jsonObject.optString("error", null)) != null) {
                this.params.put("error", _error);
            }
            if ((errorDescription = jsonObject.optString("error_description", null)) != null) {
                this.params.put("error_description", errorDescription);
            }
            if ((errorUri = jsonObject.optString("error_uri", null)) != null) {
                this.params.put("error_uri", errorUri);
            }
        }
        catch (JSONException e) {
            if (LOG.isLoggable()) {
                LOG.log("JSONException parsing response", e);
            }
            this.params.put("error", "JSONException parsing response");
        }
    }

    @Override
    public void parseQuery(String query) {
        Uri uri = Uri.parse((String)query);
        Map _params = uri.getQueryParameters();
        for (Map.Entry entry : _params.entrySet()) {
            this.params.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
        if (!this.params.containsKey("expires_in") && this.params.containsKey("expires")) {
            this.params.put("expires_in", this.params.get("expires"));
        }
    }

    @Override
    public void parseRequest(HttpServletRequest request) {
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String param = request.getParameter(paramName);
            this.params.put(paramName, param);
        }
    }

    @Override
    public void setError(OAuth2Error error) {
        this.params.put("error", error.getErrorCode());
    }

    @Override
    public void setErrorDescription(String errorDescription) {
        this.params.put("error_description", errorDescription);
    }

    @Override
    public void setErrorUri(String errorUri) {
        this.params.put("error_uri", errorUri);
    }
}

