/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.common.Nullable;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.common.servlet.Authority;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.oauth2.BasicOAuth2Request;
import org.apache.shindig.gadgets.oauth2.BasicOAuth2RequestParameterGenerator;
import org.apache.shindig.gadgets.oauth2.BasicOAuth2Store;
import org.apache.shindig.gadgets.oauth2.OAuth2FetcherConfig;
import org.apache.shindig.gadgets.oauth2.OAuth2Request;
import org.apache.shindig.gadgets.oauth2.OAuth2RequestParameterGenerator;
import org.apache.shindig.gadgets.oauth2.OAuth2Store;
import org.apache.shindig.gadgets.oauth2.handler.AuthorizationEndpointResponseHandler;
import org.apache.shindig.gadgets.oauth2.handler.ClientAuthenticationHandler;
import org.apache.shindig.gadgets.oauth2.handler.GrantRequestHandler;
import org.apache.shindig.gadgets.oauth2.handler.ResourceRequestHandler;
import org.apache.shindig.gadgets.oauth2.handler.TokenEndpointResponseHandler;
import org.apache.shindig.gadgets.oauth2.logger.FilteredLogger;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2Cache;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2Encrypter;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2PersistenceException;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2Persister;
import org.apache.shindig.gadgets.oauth2.persistence.sample.JSONOAuth2Persister;

public class OAuth2Module
extends AbstractModule {
    private static final String CLASS_NAME = OAuth2Module.class.getName();
    static final FilteredLogger LOG = FilteredLogger.getFilteredLogger(CLASS_NAME);
    public static final String OAUTH2_IMPORT = "shindig.oauth2.import";
    public static final String OAUTH2_IMPORT_CLEAN = "shindig.oauth2.import.clean";
    public static final String OAUTH2_REDIRECT_URI = "shindig.oauth2.global-redirect-uri";
    public static final String SEND_TRACE_TO_CLIENT = "shindig.oauth2.send-trace-to-client";

    protected void configure() {
        this.bind(OAuth2Store.class).toProvider(OAuth2StoreProvider.class);
        this.bind(OAuth2Request.class).toProvider(OAuth2RequestProvider.class);
        this.bind(OAuth2RequestParameterGenerator.class).to(BasicOAuth2RequestParameterGenerator.class);
        this.bind(BlobCrypter.class).annotatedWith((Annotation)Names.named((String)"shindig.oauth2.state-crypter")).toProvider(OAuth2CrypterProvider.class);
    }

    @Singleton
    public static class OAuth2CrypterProvider
    implements Provider<BlobCrypter> {
        private final BlobCrypter crypter;

        @Inject
        public OAuth2CrypterProvider(@Named(value="shindig.signing.oauth2.state-key") String stateCrypterPath) throws IOException {
            if (StringUtils.isBlank((CharSequence)stateCrypterPath)) {
                LOG.log(Level.INFO, "Using random key for OAuth2 client-side state encryption", new Object[0]);
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "OAuth2CrypterProvider constructor", "usingRandomKey");
                }
                this.crypter = new BasicBlobCrypter(Crypto.getRandomBytes((int)16));
            } else {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "OAuth2CrypterProvider constructor", new Object[]{stateCrypterPath});
                }
                this.crypter = new BasicBlobCrypter(new File(stateCrypterPath));
            }
        }

        public BlobCrypter get() {
            return this.crypter;
        }
    }

    @Singleton
    public static class OAuth2StoreProvider
    implements Provider<OAuth2Store> {
        private final BasicOAuth2Store store;

        @Inject
        public OAuth2StoreProvider(@Named(value="shindig.oauth2.global-redirect-uri") String globalRedirectUri, @Named(value="shindig.oauth2.import") boolean importFromConfig, @Named(value="shindig.oauth2.import.clean") boolean importClean, Authority authority, OAuth2Cache cache, OAuth2Persister persister, OAuth2Encrypter encrypter, @Nullable @Named(value="shindig.contextroot") String contextRoot, @Named(value="shindig.oauth2.state-crypter") BlobCrypter stateCrypter) {
            block6: {
                block5: {
                    this.store = new BasicOAuth2Store(cache, persister, encrypter, globalRedirectUri, authority, contextRoot, stateCrypter);
                    if (importFromConfig) {
                        try {
                            JSONOAuth2Persister source = new JSONOAuth2Persister(encrypter, authority, globalRedirectUri, contextRoot);
                            BasicOAuth2Store.runImport(source, persister, importClean);
                        }
                        catch (OAuth2PersistenceException e) {
                            if (!LOG.isLoggable()) break block5;
                            LOG.log("store init exception", e);
                        }
                    }
                }
                try {
                    this.store.init();
                }
                catch (GadgetException e) {
                    if (!LOG.isLoggable()) break block6;
                    LOG.log("store init exception", e);
                }
            }
        }

        public OAuth2Store get() {
            return this.store;
        }
    }

    public static class OAuth2RequestProvider
    implements Provider<OAuth2Request> {
        private final List<AuthorizationEndpointResponseHandler> authorizationEndpointResponseHandlers;
        private final List<ClientAuthenticationHandler> clientAuthenticationHandlers;
        private final OAuth2FetcherConfig config;
        private final HttpFetcher fetcher;
        private final List<GrantRequestHandler> grantRequestHandlers;
        private final List<ResourceRequestHandler> resourceRequestHandlers;
        private final List<TokenEndpointResponseHandler> tokenEndpointResponseHandlers;
        private final boolean sendTraceToClient;
        private final OAuth2RequestParameterGenerator requestParameterGenerator;

        @Inject
        public OAuth2RequestProvider(OAuth2FetcherConfig config, HttpFetcher fetcher, List<AuthorizationEndpointResponseHandler> authorizationEndpointResponseHandlers, List<ClientAuthenticationHandler> clientAuthenticationHandlers, List<GrantRequestHandler> grantRequestHandlers, List<ResourceRequestHandler> resourceRequestHandlers, List<TokenEndpointResponseHandler> tokenEndpointResponseHandlers, @Named(value="shindig.oauth2.send-trace-to-client") boolean sendTraceToClient, OAuth2RequestParameterGenerator requestParameterGenerator) {
            this.config = config;
            this.fetcher = fetcher;
            this.authorizationEndpointResponseHandlers = authorizationEndpointResponseHandlers;
            this.clientAuthenticationHandlers = clientAuthenticationHandlers;
            this.grantRequestHandlers = grantRequestHandlers;
            this.resourceRequestHandlers = resourceRequestHandlers;
            this.tokenEndpointResponseHandlers = tokenEndpointResponseHandlers;
            this.sendTraceToClient = sendTraceToClient;
            this.requestParameterGenerator = requestParameterGenerator;
        }

        public OAuth2Request get() {
            return new BasicOAuth2Request(this.config, this.fetcher, this.authorizationEndpointResponseHandlers, this.clientAuthenticationHandlers, this.grantRequestHandlers, this.resourceRequestHandlers, this.tokenEndpointResponseHandlers, this.sendTraceToClient, this.requestParameterGenerator);
        }
    }
}

