/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2;

import org.apache.shindig.gadgets.oauth2.OAuth2Error;

public class OAuth2RequestException
extends Exception {
    private static final long serialVersionUID = 7670892831898874835L;
    private final OAuth2Error error;
    private final String errorUri;
    private final String errorDescription;
    private final String errorText;

    public OAuth2RequestException(OAuth2Error error, String errorText, Throwable cause) {
        this(error, errorText, cause, "", "");
    }

    public OAuth2RequestException(OAuth2Error error, String errorText, Throwable cause, String errorUri, String errorDescription) {
        super('[' + error.name() + ',' + String.format(error.toString(), errorText) + ']', cause);
        this.error = error;
        this.errorText = error.getErrorDescription(errorText);
        this.errorUri = errorUri;
        this.errorDescription = errorDescription;
    }

    public OAuth2Error getError() {
        return this.error;
    }

    public String getErrorText() {
        return this.errorText;
    }

    @Override
    public String getMessage() {
        return this.errorText;
    }

    public String getErrorUri() {
        return this.errorUri;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    @Override
    public String toString() {
        return '[' + this.error.toString() + ',' + this.errorText + ']';
    }
}

