/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2;

import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.oauth2.logger.FilteredLogger;

public class OAuth2Utils {
    private static final String LOG_CLASS = OAuth2Utils.class.getName();
    private static final FilteredLogger LOG = FilteredLogger.getFilteredLogger(LOG_CLASS);

    public static String buildUrl(String url2, Map<String, String> queryParams, Map<String, String> fragmentParams) {
        String url = url2;
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        Uri uri = Uri.parse((String)url);
        Map existingQueryParams = uri.getQueryParameters();
        Map existingFragmentParams = uri.getFragmentParameters();
        int index = url.indexOf(63);
        String urlNoParams = url;
        if (index >= 0) {
            urlNoParams = urlNoParams.substring(0, index);
        }
        HashMap queryParams2 = Maps.newHashMapWithExpectedSize((int)5);
        if (existingQueryParams != null && !existingQueryParams.isEmpty()) {
            for (Map.Entry entry : existingQueryParams.entrySet()) {
                queryParams2.put(entry.getKey(), ((List)entry.getValue()).get(0));
            }
        }
        HashMap fragmentParams2 = Maps.newHashMapWithExpectedSize((int)5);
        if (existingFragmentParams != null && !existingFragmentParams.isEmpty()) {
            for (Map.Entry entry : existingFragmentParams.entrySet()) {
                fragmentParams2.put(entry.getKey(), ((List)entry.getValue()).get(0));
            }
        }
        if (queryParams != null) {
            queryParams2.putAll(queryParams);
        }
        if (fragmentParams != null) {
            fragmentParams2.putAll(fragmentParams);
        }
        StringBuilder buff = new StringBuilder(urlNoParams);
        if (queryParams != null && !queryParams.isEmpty()) {
            if (urlNoParams.contains("?")) {
                buff.append('&');
            } else {
                buff.append('?');
            }
            buff.append(OAuth2Utils.convertQueryString(queryParams2));
        }
        if (fragmentParams != null && !fragmentParams.isEmpty()) {
            if (urlNoParams.contains("#")) {
                buff.append('&');
            } else {
                buff.append('#');
            }
            buff.append(OAuth2Utils.convertQueryString(fragmentParams2));
        }
        return buff.toString();
    }

    public static String convertQueryString(Map<String, String> params) {
        if (params == null) {
            return "";
        }
        ArrayList<BasicNameValuePair> nvp = new ArrayList<BasicNameValuePair>();
        for (String key : new TreeSet<String>(params.keySet())) {
            if (params.get(key) == null) continue;
            nvp.add(new BasicNameValuePair(key, params.get(key)));
        }
        return URLEncodedUtils.format(nvp, (String)"UTF-8");
    }

    public static String fetchBearerTokenFromHttpRequest(HttpServletRequest req) {
        String header;
        String bearerToken = req.getParameter("access_token");
        if ((bearerToken == null || bearerToken.equals("")) && (header = req.getHeader("Authorization")) != null && header.contains("Bearer")) {
            String[] parts = header.split("\\s+");
            bearerToken = parts[parts.length - 1];
        }
        return bearerToken;
    }

    public static String fetchClientSecretFromHttpRequest(String clientId, HttpServletRequest req) {
        String header;
        String secret = req.getParameter("client_secret");
        if ((secret == null || secret.equals("")) && (header = req.getHeader("Authorization")) != null && header.contains("Basic")) {
            byte[] decodedSecret = Base64.decodeBase64((String)secret);
            try {
                String temp = new String(decodedSecret, "UTF-8");
                String[] parts = StringUtils.split((String)temp, (char)':');
                if (parts != null && parts.length == 2 && parts[0].equals(clientId)) {
                    secret = parts[1];
                }
            }
            catch (UnsupportedEncodingException e) {
                if (LOG.isLoggable()) {
                    LOG.log("UnsupportedEncodingException", e);
                }
                return null;
            }
        }
        return secret;
    }

    public static boolean isUriAllowed(Uri uri, String[] allowedDomains) {
        if (allowedDomains == null || allowedDomains.length == 0) {
            return true;
        }
        String host = uri.getAuthority();
        int pos = host.indexOf(58);
        if (pos != -1) {
            host = host.substring(0, pos);
        }
        host = host.toLowerCase();
        for (String domain : allowedDomains) {
            if (domain == null) continue;
            domain = domain.trim();
            if ((!(domain = domain.toLowerCase()).startsWith(".") || !host.endsWith(domain)) && !domain.equalsIgnoreCase(host)) continue;
            return true;
        }
        return false;
    }
}

