/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.handler;

import org.apache.commons.codec.binary.Base64;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2Error;
import org.apache.shindig.gadgets.oauth2.handler.ClientAuthenticationHandler;
import org.apache.shindig.gadgets.oauth2.handler.OAuth2HandlerError;

public class BasicAuthenticationHandler
implements ClientAuthenticationHandler {
    private static final OAuth2Error ERROR = OAuth2Error.AUTHENTICATION_PROBLEM;

    @Override
    public OAuth2HandlerError addOAuth2Authentication(HttpRequest request, OAuth2Accessor accessor) {
        try {
            if (request == null) {
                return BasicAuthenticationHandler.getError("request is null");
            }
            if (accessor == null || !accessor.isValid() || accessor.isErrorResponse()) {
                return BasicAuthenticationHandler.getError("accessor is invalid " + accessor);
            }
            String clientId = accessor.getClientId();
            if (clientId == null) {
                return BasicAuthenticationHandler.getError("client_id is null");
            }
            byte[] secretBytes = accessor.getClientSecret();
            if (secretBytes == null) {
                return BasicAuthenticationHandler.getError("client_secret is secret");
            }
            String secret = new String(secretBytes, "UTF-8");
            String authString = clientId + ':' + secret;
            byte[] authBytes = Base64.encodeBase64((byte[])authString.getBytes());
            request.setHeader("Authorization", "Basic: " + new String(authBytes));
            return null;
        }
        catch (Exception e) {
            return BasicAuthenticationHandler.getError("Exception adding basic auth headers", e);
        }
    }

    @Override
    public String geClientAuthenticationType() {
        return "Basic";
    }

    private static OAuth2HandlerError getError(String contextMessage) {
        return BasicAuthenticationHandler.getError(contextMessage, null);
    }

    private static OAuth2HandlerError getError(String contextMessage, Exception e) {
        return new OAuth2HandlerError(ERROR, contextMessage, e);
    }
}

