/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.handler;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Map;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2Error;
import org.apache.shindig.gadgets.oauth2.OAuth2Message;
import org.apache.shindig.gadgets.oauth2.OAuth2Store;
import org.apache.shindig.gadgets.oauth2.OAuth2Token;
import org.apache.shindig.gadgets.oauth2.handler.CodeAuthorizationResponseHandler;
import org.apache.shindig.gadgets.oauth2.handler.OAuth2HandlerError;
import org.apache.shindig.gadgets.oauth2.handler.TokenEndpointResponseHandler;
import org.apache.shindig.gadgets.oauth2.logger.FilteredLogger;
import org.json.JSONObject;

public class TokenAuthorizationResponseHandler
implements TokenEndpointResponseHandler {
    private static final String LOG_CLASS = CodeAuthorizationResponseHandler.class.getName();
    private static final FilteredLogger LOG = FilteredLogger.getFilteredLogger(LOG_CLASS);
    private static final OAuth2Error ERROR = OAuth2Error.TOKEN_RESPONSE_PROBLEM;
    private final Provider<OAuth2Message> oauth2MessageProvider;
    private final OAuth2Store store;

    @Inject
    public TokenAuthorizationResponseHandler(Provider<OAuth2Message> oauth2MessageProvider, OAuth2Store store) {
        this.oauth2MessageProvider = oauth2MessageProvider;
        this.store = store;
        if (LOG.isLoggable()) {
            LOG.log("this.oauth2MessageProvider = {0}", this.oauth2MessageProvider);
            LOG.log("this.store = {0}", this.store);
        }
    }

    @Override
    public OAuth2HandlerError handleResponse(OAuth2Accessor accessor, HttpResponse response) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            if (response != null) {
                LOG.entering(LOG_CLASS, "getAuthorizationBody", new Object[]{accessor, "non-null response"});
            } else {
                LOG.entering(LOG_CLASS, "getAuthorizationBody", new Object[]{accessor, null});
            }
        }
        OAuth2HandlerError ret = null;
        try {
            if (response == null) {
                ret = TokenAuthorizationResponseHandler.getError("response is null");
            }
            if (ret == null && (accessor == null || !accessor.isValid() || accessor.isErrorResponse())) {
                ret = TokenAuthorizationResponseHandler.getError("accessor is invalid " + accessor);
            }
            if (ret == null && response != null) {
                int responseCode = response.getHttpStatusCode();
                if (responseCode != 200) {
                    ret = TokenAuthorizationResponseHandler.getError("can't handle error response code " + responseCode);
                }
                if (ret == null) {
                    long issuedAt = System.currentTimeMillis();
                    String contentType = response.getHeader("Content-Type");
                    String responseString = response.getResponseAsString();
                    OAuth2Message msg = (OAuth2Message)this.oauth2MessageProvider.get();
                    if (isLogging) {
                        LOG.log("Content-Type {0}", contentType);
                        LOG.log("Response String {0}", responseString);
                    }
                    if (contentType.startsWith("application/json")) {
                        JSONObject responseJson = new JSONObject(responseString);
                        msg.parseJSON(responseJson.toString());
                    } else {
                        msg.parseQuery('?' + responseString);
                    }
                    OAuth2Error error = msg.getError();
                    if (error != null) {
                        ret = TokenAuthorizationResponseHandler.getError("error parsing request", null, msg.getErrorUri(), msg.getErrorDescription());
                    } else if (error == null && accessor != null) {
                        String accessToken = msg.getAccessToken();
                        String refreshToken = msg.getRefreshToken();
                        String expiresIn = msg.getExpiresIn();
                        String tokenType = msg.getTokenType();
                        String providerName = accessor.getServiceName();
                        String gadgetUri = accessor.getGadgetUri();
                        String scope = accessor.getScope();
                        String user = accessor.getUser();
                        String macAlgorithm = msg.getMacAlgorithm();
                        String macSecret = msg.getMacSecret();
                        Map<String, String> unparsedProperties = msg.getUnparsedProperties();
                        if (accessToken != null) {
                            OAuth2Token storedAccessToken = this.store.createToken();
                            storedAccessToken.setIssuedAt(issuedAt);
                            if (expiresIn != null) {
                                storedAccessToken.setExpiresAt(issuedAt + Long.decode(expiresIn) * 1000L);
                            } else {
                                storedAccessToken.setExpiresAt(0L);
                            }
                            storedAccessToken.setGadgetUri(gadgetUri);
                            storedAccessToken.setServiceName(providerName);
                            storedAccessToken.setScope(scope);
                            storedAccessToken.setSecret(accessToken.getBytes("UTF-8"));
                            storedAccessToken.setTokenType(tokenType);
                            storedAccessToken.setType(OAuth2Token.Type.ACCESS);
                            storedAccessToken.setUser(user);
                            if (macAlgorithm != null) {
                                storedAccessToken.setMacAlgorithm(macAlgorithm);
                            }
                            if (macSecret != null) {
                                storedAccessToken.setMacSecret(macSecret.getBytes("UTF-8"));
                            }
                            storedAccessToken.setProperties(unparsedProperties);
                            this.store.setToken(storedAccessToken);
                            accessor.setAccessToken(storedAccessToken);
                        }
                        if (refreshToken != null) {
                            OAuth2Token storedRefreshToken = this.store.createToken();
                            storedRefreshToken.setExpiresAt(0L);
                            storedRefreshToken.setGadgetUri(gadgetUri);
                            storedRefreshToken.setServiceName(providerName);
                            storedRefreshToken.setScope(scope);
                            storedRefreshToken.setSecret(refreshToken.getBytes("UTF-8"));
                            storedRefreshToken.setTokenType(tokenType);
                            storedRefreshToken.setType(OAuth2Token.Type.REFRESH);
                            storedRefreshToken.setUser(user);
                            this.store.setToken(storedRefreshToken);
                            accessor.setRefreshToken(storedRefreshToken);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            if (isLogging) {
                LOG.log("exception thrown handling authorization response", e);
            }
            return TokenAuthorizationResponseHandler.getError("exception thrown handling authorization response", e, "", "");
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "handleResponse", ret);
        }
        return ret;
    }

    @Override
    public boolean handlesResponse(OAuth2Accessor accessor, HttpResponse response) {
        if (accessor == null || !accessor.isValid() || accessor.isErrorResponse()) {
            return false;
        }
        return response != null;
    }

    private static OAuth2HandlerError getError(String contextMessage) {
        return TokenAuthorizationResponseHandler.getError(contextMessage, null, "", "");
    }

    private static OAuth2HandlerError getError(String contextMessage, Exception e, String uri, String description) {
        return new OAuth2HandlerError(ERROR, contextMessage, e, uri, description);
    }
}

