/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.logger;

import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilteredLogger {
    private static final Level DEFAULT_LOG_LEVEL = Level.FINEST;
    private static final Pattern[] filters = new Pattern[]{Pattern.compile("(?<=access_token=)[^=& \t\r\n]*"), Pattern.compile("(?<=refresh_token=)[^=& \t\r\n]*"), Pattern.compile("(?<=Authorization:)[^\t\r\n]*"), Pattern.compile("(?<=client_id:)[^\t\r\n]*"), Pattern.compile("(?<=client_id=)[^=& \t\r\n]*"), Pattern.compile("(?<=client_secret=)[^=& \t\r\n]*"), Pattern.compile("(?<=client_secret:)[^\t\r\n]*")};
    private final Logger logger;

    private static String filteredParam(Object param) {
        String paramString = param != null ? FilteredLogger.filterSecrets(param.toString()) : "";
        return paramString;
    }

    private static String[] filteredParams(Object[] params) {
        String[] paramStrings;
        if (params != null) {
            paramStrings = new String[params.length];
            int i = 0;
            for (Object param : params) {
                paramStrings[i] = param != null ? FilteredLogger.filteredParam(param.toString()) : "";
                ++i;
            }
        } else {
            paramStrings = new String[]{};
        }
        return paramStrings;
    }

    public static String filterSecrets(String in) {
        String ret = in;
        if (ret != null && ret.length() > 0) {
            for (Pattern pattern : filters) {
                Matcher m = pattern.matcher(ret);
                ret = m.replaceAll("REMOVED");
            }
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public static FilteredLogger getFilteredLogger(String className) {
        return new FilteredLogger(className);
    }

    protected FilteredLogger(String className) {
        this.logger = Logger.getLogger(className, "org.apache.shindig.gadgets.oauth2.resource");
    }

    public void entering(String sourceClass, String sourceMethod) {
        this.logger.entering(sourceClass, sourceMethod);
    }

    public void entering(String sourceClass, String sourceMethod, Object param) {
        this.logger.entering(sourceClass, sourceMethod, FilteredLogger.filteredParam(param));
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        this.logger.entering(sourceClass, sourceMethod, FilteredLogger.filteredParams(params));
    }

    public ResourceBundle getResourceBundle() {
        return this.logger.getResourceBundle();
    }

    public boolean isLoggable() {
        return this.isLoggable(DEFAULT_LOG_LEVEL);
    }

    public boolean isLoggable(Level logLevel) {
        return this.logger.isLoggable(logLevel);
    }

    public void log(Level logLevel, String msg, Object param) {
        this.logger.log(logLevel, FilteredLogger.filterSecrets(msg), FilteredLogger.filteredParam(param));
    }

    public void log(Level logLevel, String msg, Object[] params) {
        this.logger.log(logLevel, FilteredLogger.filterSecrets(msg), FilteredLogger.filteredParams(params));
    }

    public void log(Level logLevel, String msg, Throwable thrown) {
        this.logger.log(logLevel, FilteredLogger.filterSecrets(msg), thrown);
    }

    public void log(String msg, Object param) {
        this.log(DEFAULT_LOG_LEVEL, msg, param);
    }

    public void log(String msg, Object[] params) {
        this.log(DEFAULT_LOG_LEVEL, msg, params);
    }

    public void log(String msg, Throwable thrown) {
        this.logger.log(DEFAULT_LOG_LEVEL, msg, thrown);
    }

    public void exiting(String sourceClass, String sourceMethod) {
        this.logger.exiting(sourceClass, sourceMethod);
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        this.logger.exiting(sourceClass, sourceMethod, FilteredLogger.filteredParam(result));
    }
}

