/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceInputStream;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.caja.CajaCssSanitizer;
import org.apache.shindig.gadgets.render.SanitizingProxyUriManager;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.uri.ProxyUriManager;

public class SanitizingResponseRewriter
implements ResponseRewriter {
    private static final String classname = SanitizingResponseRewriter.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private final ContentRewriterFeature.Factory featureConfigFactory;
    private final CajaCssSanitizer cssSanitizer;
    private final ProxyUriManager proxyUriManager;

    @Inject
    public SanitizingResponseRewriter(ContentRewriterFeature.Factory featureConfigFactory, CajaCssSanitizer cssSanitizer, ProxyUriManager proxyUriManager) {
        this.featureConfigFactory = featureConfigFactory;
        this.cssSanitizer = cssSanitizer;
        this.proxyUriManager = proxyUriManager;
    }

    @Override
    public void rewrite(HttpRequest request, HttpResponseBuilder resp, Gadget gadget) {
        if (request.isSanitizationRequested() && this.featureConfigFactory.get(request).shouldRewriteURL(request.getUri().toString())) {
            if (Strings.isNullOrEmpty((String)request.getRewriteMimeType())) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.logp(Level.INFO, classname, "rewrite", "requestToSanitizeWithoutContent", new Object[]{request.getUri()});
                }
                resp.setContent("");
            } else if (request.getRewriteMimeType().equalsIgnoreCase("text/css")) {
                this.rewriteProxiedCss(request, resp);
            } else if (request.getRewriteMimeType().toLowerCase().startsWith("image/")) {
                this.rewriteProxiedImage(request, resp);
            } else {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.logp(Level.WARNING, classname, "rewrite", "requestToSanitizeUnknownContent", new Object[]{request.getRewriteMimeType(), request.getUri()});
                }
                resp.setContent("");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteProxiedImage(HttpRequest request, HttpResponseBuilder resp) {
        block11: {
            boolean imageIsSafe = false;
            try {
                block12: {
                    String contentType = resp.getHeader("Content-Type");
                    if (contentType != null && !contentType.toLowerCase().startsWith("image/")) break block11;
                    ImageFormat imageFormat = Sanselan.guessFormat((ByteSource)new ByteSourceInputStream(resp.getContentBytes(), request.getUri().getPath()));
                    if (imageFormat != ImageFormat.IMAGE_FORMAT_UNKNOWN) break block12;
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.logp(Level.INFO, classname, "rewriteProxiedImage", "unableToSanitizeUnknownImg", new Object[]{request.getUri().toString()});
                    }
                    return;
                }
                try {
                    imageIsSafe = true;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                catch (ImageReadException ire) {
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.logp(Level.INFO, classname, "rewriteProxiedImage", "unableToDetectImgType", new Object[]{request.getUri().toString()});
                        LOG.log(Level.INFO, ire.getMessage(), ire);
                    }
                }
            }
            finally {
                if (!imageIsSafe) {
                    resp.setContent("");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteProxiedCss(HttpRequest request, HttpResponseBuilder resp) {
        String sanitized = "";
        try {
            String contentType = resp.getHeader("Content-Type");
            if (contentType == null || contentType.toLowerCase().startsWith("text/")) {
                SanitizingProxyUriManager cssImageRewriter = new SanitizingProxyUriManager(this.proxyUriManager, "image/*");
                SanitizingProxyUriManager cssImportRewriter = new SanitizingProxyUriManager(this.proxyUriManager, "text/css");
                GadgetContext gadgetContext = DomWalker.makeGadget(request).getContext();
                sanitized = this.cssSanitizer.sanitize(resp.getContent(), request.getUri(), gadgetContext, (ProxyUriManager)cssImportRewriter, (ProxyUriManager)cssImageRewriter);
            }
        }
        finally {
            resp.setContent(sanitized);
        }
    }
}

