/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableList;
import com.google.inject.Provider;
import java.util.List;
import java.util.Map;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterList;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritePath;
import org.apache.shindig.gadgets.rewrite.RewritingException;

public class ContextAwareRegistry
implements ResponseRewriterRegistry {
    protected final GadgetHtmlParser htmlParser;
    protected final ResponseRewriterList.RewriteFlow rewriteFlow;
    protected final Provider<Map<RewritePath, Provider<List<ResponseRewriter>>>> rewritePathToRewriterList;

    public ContextAwareRegistry(GadgetHtmlParser htmlParser, ResponseRewriterList.RewriteFlow rewriteFlow, Provider<Map<RewritePath, Provider<List<ResponseRewriter>>>> rewritePathToRewriterList) {
        this.rewriteFlow = rewriteFlow;
        this.rewritePathToRewriterList = rewritePathToRewriterList;
        this.htmlParser = htmlParser;
    }

    List<ResponseRewriter> getResponseRewriters(String container) {
        RewritePath rewritePath = new RewritePath(container, this.rewriteFlow);
        Provider rewriterListProvider = (Provider)((Map)this.rewritePathToRewriterList.get()).get(rewritePath);
        if (rewriterListProvider == null) {
            rewritePath = new RewritePath("default", this.rewriteFlow);
            rewriterListProvider = (Provider)((Map)this.rewritePathToRewriterList.get()).get(rewritePath);
        }
        return rewriterListProvider != null ? (List)rewriterListProvider.get() : ImmutableList.of();
    }

    @Override
    public HttpResponse rewriteHttpResponse(HttpRequest req, HttpResponse resp, Gadget gadget) throws RewritingException {
        HttpResponseBuilder builder = new HttpResponseBuilder(this.htmlParser, resp);
        for (ResponseRewriter rewriter : this.getResponseRewriters(req.getContainer())) {
            rewriter.rewrite(req, builder, gadget);
        }
        return builder.create();
    }
}

