/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.apache.shindig.gadgets.uri.UriStatus;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImageResizeRewriter
extends DomWalker.Rewriter {
    private final ContentRewriterFeature.Factory featureConfigFactory;
    private final ProxyUriManager proxyUriManager;

    @Inject
    public ImageResizeRewriter(ProxyUriManager proxyUriManager, ContentRewriterFeature.Factory featureConfigFactory) {
        this.featureConfigFactory = featureConfigFactory;
        this.proxyUriManager = proxyUriManager;
    }

    @Override
    protected List<DomWalker.Visitor> makeVisitors(Gadget context, Uri gadgetUri) {
        ContentRewriterFeature.Config config = this.featureConfigFactory.get(context.getSpec());
        return Arrays.asList(new ImageResizeVisitor(this.proxyUriManager, config));
    }

    public static class ImageResizeVisitor
    implements DomWalker.Visitor {
        protected final ProxyUriManager proxyUriManager;
        protected final ContentRewriterFeature.Config featureConfig;

        public ImageResizeVisitor(ProxyUriManager proxyUriManager, ContentRewriterFeature.Config featureConfig) {
            this.proxyUriManager = proxyUriManager;
            this.featureConfig = featureConfig;
        }

        @Override
        public DomWalker.Visitor.VisitStatus visit(Gadget gadget, Node node) throws RewritingException {
            Element imageElement;
            if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("img") && (!this.isEmpty(imageElement = (Element)node, "height") && !this.isEmpty(imageElement, "width") && this.isEmpty(imageElement, "id") && this.isEmpty(imageElement, "class") || !this.isEmpty(imageElement, "style"))) {
                return this.addHeightWidthParams(imageElement);
            }
            return DomWalker.Visitor.VisitStatus.BYPASS;
        }

        private boolean isEmpty(Element element, String attribute) {
            return "".equals(element.getAttribute(attribute));
        }

        @Override
        public boolean revisit(Gadget gadget, List<Node> nodes) throws RewritingException {
            return true;
        }

        private DomWalker.Visitor.VisitStatus addHeightWidthParams(Element imgElement) {
            ProxyUriManager.ProxyUri proxied;
            String uriStr = imgElement.getAttribute("src").trim();
            Uri uri = Uri.parse((String)uriStr);
            try {
                proxied = this.proxyUriManager.process(uri);
            }
            catch (GadgetException e) {
                return DomWalker.Visitor.VisitStatus.BYPASS;
            }
            if (null == proxied || proxied.getStatus() == UriStatus.BAD_URI) {
                return DomWalker.Visitor.VisitStatus.BYPASS;
            }
            DomWalker.Visitor.VisitStatus status = DomWalker.Visitor.VisitStatus.BYPASS;
            Integer height = this.getIntegerPrefix(imgElement.getAttribute("height").trim());
            Integer width = this.getIntegerPrefix(imgElement.getAttribute("width").trim());
            if (null == height || null == width) {
                height = null;
                width = null;
            }
            if (!"".equals(imgElement.getAttribute("style"))) {
                String styleStr = imgElement.getAttribute("style");
                for (String attr : Splitter.on((char)';').split((CharSequence)styleStr)) {
                    Integer styleWidth;
                    Integer styleHeight;
                    String[] splits = StringUtils.split((String)attr, (char)':');
                    if (splits.length != 2) continue;
                    if ("height".equalsIgnoreCase(splits[0].trim()) && null != (styleHeight = this.getIntegerPrefix(splits[1].trim()))) {
                        height = styleHeight;
                    }
                    if (!"width".equalsIgnoreCase(splits[0].trim()) || null == (styleWidth = this.getIntegerPrefix(splits[1].trim()))) continue;
                    width = styleWidth;
                }
            }
            if (null != height && null != width) {
                proxied.setResize(width, height, null, true);
                List<Uri> updatedUri = this.proxyUriManager.make(Lists.newArrayList((Object[])new ProxyUriManager.ProxyUri[]{proxied}), this.featureConfig.getExpires());
                if (updatedUri.size() == 1) {
                    imgElement.setAttribute("src", updatedUri.get(0).toString());
                    status = DomWalker.Visitor.VisitStatus.MODIFY;
                }
            }
            return status;
        }

        private Integer getIntegerPrefix(String input) {
            String integerPrefix = "";
            if (NumberUtils.isDigits((String)input)) {
                integerPrefix = input;
            } else if (input.endsWith("px") && NumberUtils.isDigits((String)input.substring(0, input.length() - 2))) {
                integerPrefix = input.substring(0, input.length() - 2);
            }
            Integer value = null;
            if (!"".equals(integerPrefix)) {
                try {
                    value = NumberUtils.createInteger((String)integerPrefix);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            return value;
        }
    }
}

