/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.js;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.js.JsContent;
import org.apache.shindig.gadgets.js.JsResponse;
import org.apache.shindig.gadgets.js.JsResponseBuilder;
import org.apache.shindig.gadgets.rewrite.js.JsCompiler;
import org.apache.shindig.gadgets.uri.JsUriManager;

public class DefaultJsCompiler
implements JsCompiler {
    @Override
    public Iterable<JsContent> getJsContent(JsUriManager.JsUri jsUri, FeatureRegistry.FeatureBundle bundle) {
        LinkedList jsContent = Lists.newLinkedList();
        for (FeatureResource resource : bundle.getResources()) {
            String content = this.getFeatureContent(jsUri, resource);
            String string = content = content != null ? content : "";
            if (resource.isExternal()) {
                jsContent.add(JsContent.fromFeature("document.write('<script src=\"" + content + "\"></script>')", "[external:" + content + ']', bundle, resource));
            } else {
                jsContent.add(JsContent.fromFeature(content, resource.getName(), bundle, resource));
            }
            jsContent.add(JsContent.fromFeature(";\n", "[separator]", bundle, resource));
        }
        return jsContent;
    }

    @Override
    public JsResponse compile(JsUriManager.JsUri jsUri, Iterable<JsContent> content, String externs) {
        return new JsResponseBuilder().appendAllJs(content).build();
    }

    protected String getFeatureContent(JsUriManager.JsUri jsUri, FeatureResource resource) {
        return jsUri.isDebug() ? resource.getDebugContent() : resource.getContent();
    }
}

