/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.servlet.AccelHandler;
import org.apache.shindig.gadgets.servlet.ServletUtil;

public class HtmlAccelServlet
extends InjectedServlet {
    private static final long serialVersionUID = -424353123863813052L;
    private static final Logger logger = Logger.getLogger(HtmlAccelServlet.class.getName());
    private transient AccelHandler accelHandler;

    @Inject
    public void setHandler(AccelHandler accelHandler) {
        this.checkInitialized();
        this.accelHandler = accelHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse servletResponse) throws IOException {
        HttpResponse response;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Accel request = " + request.toString());
        }
        HttpRequest req = ServletUtil.fromHttpServletRequest(request);
        req.setContainer("accel");
        try {
            response = this.accelHandler.fetch(req);
        }
        catch (GadgetException e) {
            response = ServletUtil.errorResponse(e);
        }
        ServletUtil.copyToServletResponse(response, servletResponse);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }
}

