/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.servlet.JsonRpcGadgetContext;
import org.apache.shindig.gadgets.servlet.RpcException;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LinkSpec;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.uri.IframeUriManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonRpcHandler {
    protected final ExecutorService executor;
    protected final Processor processor;
    protected final IframeUriManager iframeUriManager;

    @Inject
    public JsonRpcHandler(ExecutorService executor, Processor processor, IframeUriManager iframeUriManager) {
        this.executor = executor;
        this.processor = processor;
        this.iframeUriManager = iframeUriManager;
    }

    public JSONObject process(JSONObject request) throws RpcException, JSONException {
        JSONObject requestContext = request.getJSONObject("context");
        JSONArray requestedGadgets = request.getJSONArray("gadgets");
        ArrayList gadgets = Lists.newArrayListWithCapacity((int)requestedGadgets.length());
        int j = requestedGadgets.length();
        for (int i = 0; i < j; ++i) {
            GadgetContext context = new JsonRpcGadgetContext(requestContext, requestedGadgets.getJSONObject(i));
            gadgets.add(context);
        }
        ExecutorCompletionService<JSONObject> processor = new ExecutorCompletionService<JSONObject>(this.executor);
        for (GadgetContext context : gadgets) {
            processor.submit(this.createNewJob(context));
        }
        JSONObject response = new JSONObject();
        int numJobs = gadgets.size();
        while (numJobs > 0) {
            try {
                JSONObject gadget = (JSONObject)processor.take().get();
                response.append("gadgets", (Object)gadget);
            }
            catch (InterruptedException e) {
                throw new RpcException("Processing interrupted", (Throwable)e);
            }
            catch (ExecutionException ee) {
                if (!(ee.getCause() instanceof RpcException)) {
                    throw new RpcException("Processing interrupted", (Throwable)ee);
                }
                RpcException e = (RpcException)ee.getCause();
                try {
                    GadgetContext context = e.getContext();
                    JSONObject errorObj = new JSONObject();
                    errorObj.put("url", (Object)context.getUrl()).put("moduleId", context.getModuleId());
                    errorObj.append("errors", (Object)e.getCause().getLocalizedMessage());
                    response.append("gadgets", (Object)errorObj);
                }
                catch (JSONException je) {
                    throw new RpcException("Unable to write JSON", (Throwable)je);
                }
            }
            catch (JSONException e) {
                throw new RpcException("Unable to write JSON", (Throwable)e);
            }
            finally {
                --numJobs;
            }
        }
        return response;
    }

    protected Job createNewJob(GadgetContext context) {
        return new Job(context);
    }

    protected class Job
    implements Callable<JSONObject> {
        protected final GadgetContext context;

        public Job(GadgetContext context) {
            this.context = context;
        }

        @Override
        public JSONObject call() throws RpcException {
            try {
                Gadget gadget = JsonRpcHandler.this.processor.process(this.context);
                GadgetSpec spec = gadget.getSpec();
                return this.getGadgetJson(gadget, spec);
            }
            catch (Exception e) {
                throw new RpcException(this.context, (Throwable)e);
            }
        }

        protected JSONObject getGadgetJson(Gadget gadget, GadgetSpec spec) throws JSONException {
            JSONObject gadgetJson = new JSONObject();
            ModulePrefs prefs = spec.getModulePrefs();
            JSONObject views = new JSONObject();
            for (View view : spec.getViews().values()) {
                JSONObject jv = new JSONObject().put("type", (Object)view.getType().toString()).put("quirks", view.getQuirks()).put("preferredHeight", view.getPreferredHeight()).put("preferredWidth", view.getPreferredWidth());
                Map<String, String> vattrs = view.getAttributes();
                if (!vattrs.isEmpty()) {
                    JSONObject ja = new JSONObject(vattrs);
                    jv.put("attributes", (Object)ja);
                }
                views.put(view.getName(), (Object)jv);
            }
            Set<String> feats = prefs.getFeatures().keySet();
            String[] features = feats.toArray(new String[feats.size()]);
            JSONObject featureDetailList = new JSONObject();
            for (Feature featureSpec : prefs.getFeatures().values()) {
                JSONObject featureDetail = new JSONObject();
                featureDetail.put("required", featureSpec.getRequired());
                JSONObject featureParameters = new JSONObject();
                featureDetail.put("parameters", (Object)featureParameters);
                Multimap<String, String> featureParams = featureSpec.getParams();
                for (String paramName : featureParams.keySet()) {
                    featureParameters.put(paramName, featureParams.get((Object)paramName));
                }
                featureDetailList.put(featureSpec.getName(), (Object)featureDetail);
            }
            JSONObject links = new JSONObject();
            for (LinkSpec link : prefs.getLinks().values()) {
                links.put(link.getRel(), (Object)link.getHref());
            }
            JSONObject userPrefs = new JSONObject();
            for (UserPref pref : spec.getUserPrefs().values()) {
                JSONObject up = new JSONObject().put("displayName", (Object)pref.getDisplayName()).put("type", (Object)pref.getDataType().toString().toLowerCase()).put("default", (Object)pref.getDefaultValue()).put("enumValues", pref.getEnumValues()).put("orderedEnumValues", this.getOrderedEnums(pref));
                userPrefs.put(pref.getName(), (Object)up);
            }
            gadgetJson.put("iframeUrl", (Object)JsonRpcHandler.this.iframeUriManager.makeRenderingUri(gadget).toString()).put("url", (Object)this.context.getUrl().toString()).put("moduleId", this.context.getModuleId()).put("title", (Object)prefs.getTitle()).put("titleUrl", (Object)prefs.getTitleUrl().toString()).put("views", (Object)views).put("features", (Object)features).put("featureDetails", (Object)featureDetailList).put("userPrefs", (Object)userPrefs).put("links", (Object)links).put("directoryTitle", (Object)prefs.getDirectoryTitle()).put("thumbnail", (Object)prefs.getThumbnail().toString()).put("screenshot", (Object)prefs.getScreenshot().toString()).put("author", (Object)prefs.getAuthor()).put("authorEmail", (Object)prefs.getAuthorEmail()).put("authorAffiliation", (Object)prefs.getAuthorAffiliation()).put("authorLocation", (Object)prefs.getAuthorLocation()).put("authorPhoto", (Object)prefs.getAuthorPhoto()).put("authorAboutme", (Object)prefs.getAuthorAboutme()).put("authorQuote", (Object)prefs.getAuthorQuote()).put("authorLink", (Object)prefs.getAuthorLink()).put("categories", prefs.getCategories()).put("screenshot", (Object)prefs.getScreenshot().toString()).put("height", prefs.getHeight()).put("width", prefs.getWidth()).put("showStats", prefs.getShowStats()).put("showInDirectory", prefs.getShowInDirectory()).put("singleton", prefs.getSingleton()).put("scaling", prefs.getScaling()).put("scrolling", prefs.getScrolling());
            return gadgetJson;
        }

        private List<JSONObject> getOrderedEnums(UserPref pref) throws JSONException {
            List<UserPref.EnumValuePair> orderedEnums = pref.getOrderedEnumValues();
            ArrayList jsonEnums = Lists.newArrayListWithCapacity((int)orderedEnums.size());
            for (UserPref.EnumValuePair evp : orderedEnums) {
                JSONObject curEnum = new JSONObject();
                curEnum.put("value", (Object)evp.getValue());
                curEnum.put("displayValue", (Object)evp.getDisplayValue());
                jsonEnums.add(curEnum);
            }
            return jsonEnums;
        }
    }
}

