/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.gadgets.uri.UriCommon;

public class RpcSwfServlet
extends HttpServlet {
    private static final String SWF_RESOURCE_NAME = "files/xpc.swf";
    private static final int ONE_YEAR_IN_SEC = 31536000;
    private static final int DEFAULT_SWF_TTL = 86400;
    private final byte[] swfBytes;
    private final String hash;
    private int defaultSwfTtl = 86400;

    public RpcSwfServlet() {
        this(SWF_RESOURCE_NAME);
    }

    public RpcSwfServlet(String swfResource) {
        try {
            InputStream is = ResourceLoader.openResource((String)swfResource);
            if (is == null) {
                throw new RuntimeException("Failed to locate Flash SWF");
            }
            this.swfBytes = IOUtils.toByteArray((InputStream)is);
            this.hash = HashUtil.checksum((byte[])this.swfBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Inject(optional=true)
    public void setDefaultRpcSwfTtl(@Named(value="shindig.rpc.swf.defaultTtl") Integer defaultTtl) {
        this.defaultSwfTtl = defaultTtl;
    }

    public String getSwfHash() {
        return this.hash;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        String v = req.getParameter(UriCommon.Param.VERSION.getKey());
        if (v != null && v.equals(this.hash)) {
            HttpUtil.setCachingHeaders((HttpServletResponse)resp, (int)31536000, (boolean)true);
        } else {
            HttpUtil.setCachingHeaders((HttpServletResponse)resp, (int)this.defaultSwfTtl, (boolean)true);
        }
        resp.setHeader("Content-Type", "application/x-shockwave-flash");
        resp.getOutputStream().write(this.swfBytes);
    }
}

