/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Feature {
    public static final Feature CORE_FEATURE = new Feature("core");
    public static final Feature SECURITY_TOKEN_FEATURE = new Feature("security-token");
    private final String name;
    private final Multimap<String, String> params;
    private final boolean required;
    private final Set<String> views;

    private Feature(String name) {
        this.params = ImmutableMultimap.of();
        this.required = true;
        this.name = name;
        this.views = ImmutableSet.of();
    }

    public String getName() {
        return this.name;
    }

    public Multimap<String, String> getParams() {
        return this.params;
    }

    public String getParam(String key) {
        Collection values = this.params.get((Object)key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.iterator().next();
    }

    public Collection<String> getParamCollection(String key) {
        return this.params.get((Object)key);
    }

    public boolean getRequired() {
        return this.required;
    }

    public Set<String> getViews() {
        return this.views;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.required ? "<Require" : "<Optional").append(" feature=\"").append(this.name);
        if (!this.views.isEmpty()) {
            buf.append("\" views=\"").append(StringUtils.join(this.views, (char)','));
        }
        buf.append("\">");
        for (Map.Entry entry : this.params.asMap().entrySet()) {
            buf.append("\n<Param name=\"").append((String)entry.getKey()).append("\">").append(entry.getValue()).append("</Param>");
        }
        buf.append(this.required ? "</Require>" : "</Optional>");
        return buf.toString();
    }

    public Feature(Element feature) throws SpecParserException {
        this.required = feature.getNodeName().equals("Require");
        String name = XmlUtil.getAttribute((Node)feature, (String)"feature");
        if (name == null) {
            throw new SpecParserException((this.required ? "Require" : "Optional") + "@feature is required.");
        }
        this.name = name;
        NodeList children = feature.getElementsByTagName("Param");
        if (children.getLength() > 0) {
            ImmutableMultimap.Builder params = ImmutableMultimap.builder();
            int j = children.getLength();
            for (int i = 0; i < j; ++i) {
                Element param = (Element)children.item(i);
                String paramName = XmlUtil.getAttribute((Node)param, (String)"name");
                if (paramName == null) {
                    throw new SpecParserException("Param@name is required");
                }
                params.put((Object)paramName, (Object)param.getTextContent());
            }
            this.params = params.build();
        } else {
            this.params = ImmutableMultimap.of();
        }
        String viewNames = XmlUtil.getAttribute((Node)feature, (String)"views", (String)"").trim();
        this.views = ImmutableSet.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)viewNames));
    }

    public Feature(String name, Multimap<String, String> params, boolean required, Set<String> views) {
        this.name = name;
        this.params = params;
        this.required = required;
        this.views = views;
    }
}

