/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.uri.JsUriManager;
import org.apache.shindig.gadgets.uri.UriStatus;

public class DefaultJsVersioner
implements JsUriManager.Versioner {
    private final FeatureRegistry registry;
    private final Map<List<FeatureResource>, String> versionCache;

    @Inject
    public DefaultJsVersioner(FeatureRegistry registry) {
        this.registry = registry;
        this.versionCache = Maps.newHashMap();
    }

    @Override
    public String version(final JsUriManager.JsUri jsUri) {
        GadgetContext ctx = new GadgetContext(){

            @Override
            public String getContainer() {
                return jsUri.getContainer();
            }

            @Override
            public RenderingContext getRenderingContext() {
                return jsUri.getContext();
            }
        };
        List<FeatureResource> resources = this.registry.getFeatureResources(ctx, jsUri.getLibs(), null).getResources();
        if (this.versionCache.containsKey(resources)) {
            return this.versionCache.get(resources);
        }
        StringBuilder jsBuf = new StringBuilder();
        for (FeatureResource resource : resources) {
            jsBuf.append(resource.getContent()).append(resource.getDebugContent());
        }
        String checksum = HashUtil.checksum((byte[])jsBuf.toString().getBytes());
        this.versionCache.put(resources, checksum);
        return checksum;
    }

    @Override
    public UriStatus validate(JsUriManager.JsUri jsUri, String version) {
        if (version == null || version.length() == 0) {
            return UriStatus.VALID_UNVERSIONED;
        }
        String expectedVersion = this.version(jsUri);
        if (version.equals(expectedVersion)) {
            return UriStatus.VALID_VERSIONED;
        }
        return UriStatus.INVALID_VERSION;
    }
}

