/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.variables;

import com.google.inject.Inject;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.apache.shindig.gadgets.variables.Substituter;
import org.apache.shindig.gadgets.variables.Substitutions;

public class BidiSubstituter
implements Substituter {
    public static final String START_EDGE = "START_EDGE";
    public static final String END_EDGE = "END_EDGE";
    public static final String DIR = "DIR";
    public static final String REVERSE_DIR = "REVERSE_DIR";
    public static final String RIGHT = "right";
    public static final String LEFT = "left";
    public static final String RTL = "rtl";
    public static final String LTR = "ltr";
    private final MessageBundleFactory messageBundleFactory;

    @Inject
    public BidiSubstituter(MessageBundleFactory messageBundleFactory) {
        this.messageBundleFactory = messageBundleFactory;
    }

    @Override
    public void addSubstitutions(Substitutions substituter, GadgetContext context, GadgetSpec spec) throws GadgetException {
        MessageBundle bundle = this.messageBundleFactory.getBundle(spec, context.getLocale(), context.getIgnoreCache(), context.getContainer(), context.getView());
        String dir = bundle.getLanguageDirection();
        boolean rtl = RTL.equals(dir);
        substituter.addSubstitution(Substitutions.Type.BIDI, START_EDGE, rtl ? RIGHT : LEFT);
        substituter.addSubstitution(Substitutions.Type.BIDI, END_EDGE, rtl ? LEFT : RIGHT);
        substituter.addSubstitution(Substitutions.Type.BIDI, DIR, rtl ? RTL : LTR);
        substituter.addSubstitution(Substitutions.Type.BIDI, REVERSE_DIR, rtl ? LTR : RTL);
    }
}

