/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.variables;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.UserPrefs;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.variables.Substituter;
import org.apache.shindig.gadgets.variables.Substitutions;

public class UserPrefSubstituter
implements Substituter {
    @Override
    public void addSubstitutions(Substitutions substituter, GadgetContext context, GadgetSpec spec) {
        UserPrefs values = context.getUserPrefs();
        for (UserPref pref : spec.getUserPrefs().values()) {
            String name = pref.getName();
            String value = values.getPref(name);
            if (value == null && (value = pref.getDefaultValue()) == null) {
                value = "";
            }
            substituter.addSubstitution(Substitutions.Type.USER_PREF, name, StringEscapeUtils.escapeHtml4((String)value));
        }
    }
}

