/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.application;

import java.util.LinkedHashMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class ProfileUpdatesPublisher
extends ProfileListenerPlugin {
    public static final String USER_NAME_PARAM = "USER_NAME_PARAM";
    public static final String USER_POSITION_PARAM = "USER_POSITION_PARAM";
    public static final String POSITION_TITLE_ID = "position_updated";
    private static final Log LOG = ExoLogger.getLogger(ProfileUpdatesPublisher.class);
    private static final String BREAKLINE_STR = "<br />";
    public static final String ABOUT_ME_UPDATED = "aboutMe_section_updated";
    public static final String AVATAR_UPDATED = "avatar_updated";
    public static final String BASIC_INFO_UPDATED = "basic_info_updated";
    public static final String CONTACT_UPDATED = "contact_section_updated";
    public static final String EX_SECTION_UPDATED = "experience_section_updated";
    private ActivityManager activityManager;
    private IdentityManager identityManager;

    public ProfileUpdatesPublisher(InitParams params, ActivityManager activityManager, IdentityManager identityManager) {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
    }

    @Override
    public void avatarUpdated(ProfileLifeCycleEvent event) {
        this.publishActivity(event, AVATAR_UPDATED);
    }

    @Override
    public void bannerUpdated(ProfileLifeCycleEvent event) {
        LOG.debug("Profile banner of user {} has been updated", new Object[]{event.getProfile().getIdentity().getId()});
    }

    @Override
    public void basicInfoUpdated(ProfileLifeCycleEvent event) {
        this.publishActivity(event, BASIC_INFO_UPDATED);
    }

    @Override
    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        this.publishActivity(event, CONTACT_UPDATED);
    }

    @Override
    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
        this.publishActivity(event, EX_SECTION_UPDATED);
    }

    @Override
    public void headerSectionUpdated(ProfileLifeCycleEvent event) {
        this.publishActivity(event, POSITION_TITLE_ID);
    }

    private ExoSocialActivity createComment(String title, String titleId, Identity identity, String position) {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(title);
        comment.setUserId(identity.getId());
        comment.setType("exosocial:people");
        comment.setTitleId(titleId);
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        if (POSITION_TITLE_ID.equals(titleId)) {
            templateParams.put(USER_POSITION_PARAM, StringEscapeUtils.unescapeHtml((String)position));
            templateParams.put("registeredKeysForProcessor", USER_POSITION_PARAM);
        }
        comment.setTemplateParams(templateParams);
        return comment;
    }

    private void publishActivity(ProfileLifeCycleEvent event, String titleId) {
        String activityId = this.getStorage().getProfileActivityId(event.getProfile(), Profile.AttachedActivityType.USER);
        ExoSocialActivityImpl activity = (ExoSocialActivityImpl)this.activityManager.getActivity(activityId);
        if (activity == null) {
            activity = new ExoSocialActivityImpl();
            activity.setType("USER_PROFILE_ACTIVITY");
            activityId = null;
        }
        String existingActivityTitle = activity.getTitle();
        StringBuilder sb = new StringBuilder();
        String breakLine = "";
        for (Profile.UpdateType ut : event.getProfile().getListUpdateTypes()) {
            sb.append(breakLine);
            sb.append(ActivityMessages.getActivityMessage(ut));
            breakLine = BREAKLINE_STR;
        }
        String newActivityTitle = sb.toString();
        activity.setTitle(newActivityTitle);
        boolean hasUpdated = false;
        if (StringUtils.isNotBlank((String)titleId)) {
            String newTitleId = activity.getTitleId() == null ? titleId : activity.getTitleId().replace(titleId, "") + "," + titleId;
            activity.setTitleId(newTitleId);
            hasUpdated = true;
        }
        if (activityId != null && (hasUpdated |= newActivityTitle.replaceAll(BREAKLINE_STR, "").length() > 0 && !newActivityTitle.equals(existingActivityTitle))) {
            this.activityManager.updateActivity(activity);
        }
        this.publish(event, activity, activityId, titleId);
    }

    private void publish(ProfileLifeCycleEvent event, ExoSocialActivity activity, String activityId, String titleId) {
        Profile profile = event.getProfile();
        Identity identity = profile.getIdentity();
        try {
            this.reloadIfNeeded(identity);
            if (activityId == null) {
                this.activityManager.saveActivityNoReturn(identity, activity);
                this.getStorage().updateProfileActivityId(identity, activity.getId(), Profile.AttachedActivityType.USER);
            }
            ExoSocialActivity comment = this.createComment(activity.getTitle(), titleId, identity, event.getProfile().getPosition());
            this.activityManager.saveComment(activity, comment);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to publish event " + (Object)((Object)event) + ": " + e.getMessage()));
        }
    }

    private void reloadIfNeeded(Identity id1) throws Exception {
        if (id1.getId() == null || id1.getProfile().getFullName().length() == 0) {
            id1 = this.identityManager.getIdentity(id1.getGlobalId().toString(), true);
        }
    }

    private IdentityStorage getStorage() {
        return (IdentityStorage)PortalContainer.getInstance().getComponentInstanceOfType(IdentityStorage.class);
    }

    @Override
    public void createProfile(ProfileLifeCycleEvent event) {
    }

    @Override
    public void aboutMeUpdated(ProfileLifeCycleEvent event) {
        this.publishActivity(event, ABOUT_ME_UPDATED);
    }

    static enum ActivityMessages {
        POSITION(Profile.UpdateType.POSITION, "Position is now: "),
        BASIC_INFOR(Profile.UpdateType.BASIC_INFOR, "Basic informations has been updated."),
        CONTACT(Profile.UpdateType.CONTACT, "Contact informations has been updated."),
        EXPERIENCES(Profile.UpdateType.EXPERIENCES, "Experiences has been updated."),
        AVATAR(Profile.UpdateType.AVATAR, "Avatar has been updated."),
        ABOUT_ME(Profile.UpdateType.ABOUT_ME, "About me has been updated.");

        private final Profile.UpdateType key;
        private final String msg;

        private ActivityMessages(Profile.UpdateType key, String msg) {
            this.key = key;
            this.msg = msg;
        }

        Profile.UpdateType getKey() {
            return this.key;
        }

        public String getMsg() {
            return this.msg;
        }

        public static String getActivityMessage(Profile.UpdateType key) {
            for (ActivityMessages am : ActivityMessages.values()) {
                if (!am.getKey().equals((Object)key)) continue;
                return am.getMsg();
            }
            return "";
        }
    }
}

