/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.chromattic.entity;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.DefaultValue;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.social.core.chromattic.entity.ActivityEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityRef;
import org.exoplatform.social.core.chromattic.entity.ActivityRefDayEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityRefYearEntity;

@PrimaryType(name="soc:activityreflist")
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@NamingPrefix(value="soc")
public abstract class ActivityRefListEntity {
    protected String[] MONTH_NAME = new DateFormatSymbols(Locale.ENGLISH).getMonths();

    @Path
    public abstract String getPath();

    @Property(name="soc:number")
    @DefaultValue(value={"0"})
    public abstract Integer getNumber();

    public abstract void setNumber(Integer var1);

    @Property(name="soc:lastMigration")
    @DefaultValue(value={"0"})
    public abstract Long getLastMigration();

    public abstract void setLastMigration(Long var1);

    @OneToMany
    public abstract Map<String, ActivityRefYearEntity> getYears();

    @OneToMany
    public abstract List<ActivityRefYearEntity> getYearsList();

    @Create
    public abstract ActivityRefYearEntity newYear();

    @Create
    public abstract ActivityRefYearEntity newYear(String var1);

    public void inc() {
        this.setNumber(this.getNumber() + 1);
    }

    public void desc() {
        this.setNumber(this.getNumber() - 1);
    }

    public ActivityRefYearEntity getYear(String year) {
        ActivityRefYearEntity yearEntity = null;
        yearEntity = this.getYears() == null ? this.newYear(year) : this.getYears().get(year);
        if (yearEntity == null) {
            yearEntity = this.newYear();
            this.getYears().put(year, yearEntity);
            long longYear = Long.parseLong(year);
            for (int i = this.getYearsList().size() - 1; i >= 0; --i) {
                long longCurrent = Long.parseLong(this.getYearsList().get(i).getName());
                if (longCurrent >= longYear) continue;
                this.getYearsList().add(i, yearEntity);
            }
        }
        return yearEntity;
    }

    public ActivityRefYearEntity getYear(String year, AtomicBoolean newYearMonthDay) {
        ActivityRefYearEntity yearEntity = null;
        yearEntity = this.getYears() == null ? this.newYear(year) : this.getYears().get(year);
        if (yearEntity == null) {
            yearEntity = this.newYear();
            this.getYears().put(year, yearEntity);
            long longYear = Long.parseLong(year);
            for (int i = this.getYearsList().size() - 1; i >= 0; --i) {
                long longCurrent = Long.parseLong(this.getYearsList().get(i).getName());
                if (longCurrent >= longYear) continue;
                this.getYearsList().add(i, yearEntity);
            }
            newYearMonthDay.set(true);
        }
        return yearEntity;
    }

    public ActivityRef getOrCreated(ActivityEntity entity, boolean isHidden) {
        Long lastUpdated = entity.getLastUpdated() != null ? entity.getLastUpdated() : entity.getPostedTime();
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        calendar.setTimeInMillis(lastUpdated);
        String year = String.valueOf(calendar.get(1));
        String month = this.MONTH_NAME[calendar.get(2)];
        String day = String.valueOf(calendar.get(5));
        ActivityRefDayEntity dayEntity = this.getYear(year).getMonth(month).getDay(day);
        ActivityRef ref = dayEntity.getActivityRefs().get(entity.getId());
        if (ref == null) {
            ref = dayEntity.createRef();
            ref.setName(entity.getId());
            dayEntity.getActivityRefList().add(ref);
            ref.setLastUpdated(lastUpdated);
            ref.setActivityEntity(entity);
            if (!isHidden) {
                dayEntity.inc();
            }
        }
        return ref;
    }

    public ActivityRef get(ActivityEntity entity, Long oldLastUpdated) {
        Long lastUpdated = oldLastUpdated;
        if (oldLastUpdated == null) {
            lastUpdated = entity.getLastUpdated() != null ? entity.getLastUpdated() : entity.getPostedTime();
        }
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        calendar.setTimeInMillis(lastUpdated);
        String year = String.valueOf(calendar.get(1));
        String month = this.MONTH_NAME[calendar.get(2)];
        String day = String.valueOf(calendar.get(5));
        ActivityRefDayEntity dayEntity = this.getYear(year).getMonth(month).getDay(day);
        ActivityRef ref = dayEntity.getActivityRefs().get(entity.getId());
        if (ref == null) {
            ref = dayEntity.getActivityRefs().get("" + lastUpdated);
        }
        return ref;
    }

    public ActivityRefDayEntity getActivityRefDay(long lastUpdated) {
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        calendar.setTimeInMillis(lastUpdated);
        String year = String.valueOf(calendar.get(1));
        String month = this.MONTH_NAME[calendar.get(2)];
        String day = String.valueOf(calendar.get(5));
        return this.getYear(year).getMonth(month).getDay(day);
    }

    public void update(ActivityEntity entity, ActivityRef old, long oldLastUpdated, boolean isHidden) {
        Calendar oldCalendar = Calendar.getInstance(Locale.ENGLISH);
        oldCalendar.setTimeInMillis(oldLastUpdated);
        String oldYear = String.valueOf(oldCalendar.get(1));
        String oldMonth = this.MONTH_NAME[oldCalendar.get(2)];
        String oldDay = String.valueOf(oldCalendar.get(5));
        Long lastUpdated = entity.getLastUpdated() != null ? entity.getLastUpdated() : entity.getPostedTime();
        Calendar newCalendar = Calendar.getInstance(Locale.ENGLISH);
        newCalendar.setTimeInMillis(lastUpdated);
        String newYear = String.valueOf(newCalendar.get(1));
        String newMonth = this.MONTH_NAME[newCalendar.get(2)];
        String newDay = String.valueOf(newCalendar.get(5));
        ActivityRefDayEntity oldDayEntity = this.getYear(oldYear).getMonth(oldMonth).getDay(oldDay);
        ActivityRef oldRef = oldDayEntity.getActivityRefs().get(entity.getId());
        if (oldRef == null) {
            oldRef = oldDayEntity.getActivityRefs().get(old.getName());
        }
        if (oldRef != null) {
            if (!(oldYear.equalsIgnoreCase(newYear) && oldMonth.equalsIgnoreCase(newMonth) && oldDay.equalsIgnoreCase(newDay))) {
                oldDayEntity.getActivityRefs().remove(oldRef.getName());
                if (!isHidden) {
                    oldDayEntity.desc();
                }
                this.getOrCreated(entity, isHidden);
            } else {
                oldRef.setLastUpdated(lastUpdated);
            }
        }
    }

    public Map<String, ActivityRef> refs(long lastUpdated) {
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        calendar.setTimeInMillis(lastUpdated);
        String year = String.valueOf(calendar.get(1));
        String month = this.MONTH_NAME[calendar.get(2)];
        String day = String.valueOf(calendar.get(5));
        ActivityRefDayEntity dayEntity = this.getYear(year).getMonth(month).getDay(day);
        return dayEntity.getActivityRefs();
    }

    public boolean isOnlyUpdate(long oldLastUpdated, long newLastUpdated) {
        Calendar oldCalendar = Calendar.getInstance(Locale.ENGLISH);
        oldCalendar.setTimeInMillis(oldLastUpdated);
        Calendar newCalendar = Calendar.getInstance(Locale.ENGLISH);
        newCalendar.setTimeInMillis(newLastUpdated);
        String oldYear = String.valueOf(oldCalendar.get(1));
        String oldMonth = this.MONTH_NAME[oldCalendar.get(2)];
        String oldDay = String.valueOf(oldCalendar.get(5));
        String newYear = String.valueOf(newCalendar.get(1));
        String newMonth = this.MONTH_NAME[newCalendar.get(2)];
        String newDay = String.valueOf(newCalendar.get(5));
        boolean isOnlyUpdate = oldYear.equals(newYear) && oldMonth.equals(newMonth) && oldDay.equals(newDay);
        return isOnlyUpdate;
    }

    public boolean isOnlyUpdate(ActivityRef oldRef, long newLastUpdated) {
        ActivityRefDayEntity day = oldRef.getDay();
        String oldYear = day.getMonth().getYear().getName();
        String oldMonth = day.getMonth().getName();
        String oldDay = day.getName();
        Calendar newCalendar = Calendar.getInstance(Locale.ENGLISH);
        newCalendar.setTimeInMillis(newLastUpdated);
        String newYear = String.valueOf(newCalendar.get(1));
        String newMonth = this.MONTH_NAME[newCalendar.get(2)];
        String newDay = String.valueOf(newCalendar.get(5));
        boolean isOnlyUpdate = oldYear.equals(newYear) && oldMonth.equals(newMonth) && oldDay.equals(newDay);
        return isOnlyUpdate;
    }

    public ActivityRef remove(ActivityEntity entity, boolean isHidden, Long oldLastUpdated) {
        Long lastUpdated = oldLastUpdated;
        if (oldLastUpdated == null) {
            lastUpdated = entity.getLastUpdated() != null ? entity.getLastUpdated() : entity.getPostedTime();
        }
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        calendar.setTimeInMillis(lastUpdated);
        String year = String.valueOf(calendar.get(1));
        String month = this.MONTH_NAME[calendar.get(2)];
        String day = String.valueOf(calendar.get(5));
        ActivityRefDayEntity dayEntity = this.getYear(year).getMonth(month).getDay(day);
        ActivityRef ref = dayEntity.getActivityRefs().remove(entity.getId());
        if (ref == null) {
            ref = dayEntity.getActivityRefs().remove("" + lastUpdated);
        }
        if (ref != null) {
            if (!isHidden) {
                dayEntity.desc();
            }
            ref = null;
        }
        return ref;
    }
}

