/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.ActiveIdentityFilter;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.IdentityWithRelationship;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profile.ProfileLoader;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.cache.CacheType;
import org.exoplatform.social.core.storage.cache.CachedRelationshipStorage;
import org.exoplatform.social.core.storage.cache.FutureExoCache;
import org.exoplatform.social.core.storage.cache.SocialStorageCacheService;
import org.exoplatform.social.core.storage.cache.loader.ServiceContext;
import org.exoplatform.social.core.storage.cache.model.data.ActiveIdentitiesData;
import org.exoplatform.social.core.storage.cache.model.data.IdentityData;
import org.exoplatform.social.core.storage.cache.model.data.IntegerData;
import org.exoplatform.social.core.storage.cache.model.data.ListIdentitiesData;
import org.exoplatform.social.core.storage.cache.model.data.ProfileData;
import org.exoplatform.social.core.storage.cache.model.key.ActiveIdentityKey;
import org.exoplatform.social.core.storage.cache.model.key.IdentityCompositeKey;
import org.exoplatform.social.core.storage.cache.model.key.IdentityFilterKey;
import org.exoplatform.social.core.storage.cache.model.key.IdentityKey;
import org.exoplatform.social.core.storage.cache.model.key.ListIdentitiesKey;
import org.exoplatform.social.core.storage.cache.model.key.ListSpaceMembersKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceKey;
import org.exoplatform.social.core.storage.cache.selector.IdentityCacheSelector;

public class CachedIdentityStorage
implements IdentityStorage {
    private static final Log LOG = ExoLogger.getLogger(CachedIdentityStorage.class);
    private final ExoCache<IdentityKey, IdentityData> exoIdentityCache;
    private final ExoCache<IdentityCompositeKey, IdentityKey> exoIdentityIndexCache;
    private final ExoCache<IdentityKey, ProfileData> exoProfileCache;
    private final ExoCache<IdentityFilterKey, IntegerData> exoIdentitiesCountCache;
    private final ExoCache<ListIdentitiesKey, ListIdentitiesData> exoIdentitiesCache;
    private final ExoCache<ActiveIdentityKey, ActiveIdentitiesData> exoActiveIdentitiesCache;
    private final FutureExoCache<IdentityKey, IdentityData, ServiceContext<IdentityData>> identityCache;
    private final FutureExoCache<IdentityCompositeKey, IdentityKey, ServiceContext<IdentityKey>> identityIndexCache;
    private final FutureExoCache<IdentityKey, ProfileData, ServiceContext<ProfileData>> profileCache;
    private final FutureExoCache<IdentityFilterKey, IntegerData, ServiceContext<IntegerData>> identitiesCountCache;
    private final FutureExoCache<ListIdentitiesKey, ListIdentitiesData, ServiceContext<ListIdentitiesData>> identitiesCache;
    private final FutureExoCache<ActiveIdentityKey, ActiveIdentitiesData, ServiceContext<ActiveIdentitiesData>> activeIdentitiesCache;
    private final IdentityStorage storage;
    private CachedRelationshipStorage cachedRelationshipStorage;

    void clearCache() {
        try {
            this.exoIdentitiesCache.select((CachedObjectSelector)new IdentityCacheSelector("organization"));
            this.exoIdentitiesCountCache.select((CachedObjectSelector)new IdentityCacheSelector("organization"));
        }
        catch (Exception e) {
            LOG.error((Object)"Error when clearing cache", (Throwable)e);
        }
    }

    private CachedRelationshipStorage getCachedRelationshipStorage() {
        if (this.cachedRelationshipStorage == null) {
            this.cachedRelationshipStorage = (CachedRelationshipStorage)PortalContainer.getInstance().getComponentInstanceOfType(CachedRelationshipStorage.class);
        }
        return this.cachedRelationshipStorage;
    }

    private List<Identity> buildIdentities(ListIdentitiesData data) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        for (IdentityKey k : data.getIds()) {
            Identity gotIdentity = this.findIdentityById(k.getId());
            gotIdentity.setProfile(this.loadProfile(gotIdentity.getProfile()));
            identities.add(gotIdentity);
        }
        return identities;
    }

    private ListIdentitiesData buildIds(List<Identity> identities) {
        ArrayList<IdentityKey> data = new ArrayList<IdentityKey>();
        for (Identity i : identities) {
            IdentityKey k = new IdentityKey(i);
            if (this.exoIdentityCache.get((Serializable)k) == null) {
                this.exoIdentityCache.putLocal((Serializable)k, (Object)new IdentityData(i));
            }
            if (this.exoProfileCache.get((Serializable)k) == null) {
                this.exoProfileCache.putLocal((Serializable)k, (Object)new ProfileData(i.getProfile()));
            }
            data.add(new IdentityKey(i));
        }
        return new ListIdentitiesData((List<IdentityKey>)data);
    }

    public CachedIdentityStorage(IdentityStorage storage, SocialStorageCacheService cacheService) {
        this.storage = storage;
        this.exoIdentityCache = cacheService.getIdentityCache();
        this.exoIdentityIndexCache = cacheService.getIdentityIndexCache();
        this.exoProfileCache = cacheService.getProfileCache();
        this.exoIdentitiesCountCache = cacheService.getCountIdentitiesCache();
        this.exoIdentitiesCache = cacheService.getIdentitiesCache();
        this.exoActiveIdentitiesCache = cacheService.getActiveIdentitiesCache();
        this.identityCache = CacheType.IDENTITY.createFutureCache(this.exoIdentityCache);
        this.identityIndexCache = CacheType.IDENTITY_INDEX.createFutureCache(this.exoIdentityIndexCache);
        this.profileCache = CacheType.PROFILE.createFutureCache(this.exoProfileCache);
        this.identitiesCountCache = CacheType.IDENTITIES_COUNT.createFutureCache(this.exoIdentitiesCountCache);
        this.identitiesCache = CacheType.IDENTITIES.createFutureCache(this.exoIdentitiesCache);
        this.activeIdentitiesCache = CacheType.ACTIVE_IDENTITIES.createFutureCache(this.exoActiveIdentitiesCache);
    }

    @Override
    public void saveIdentity(Identity identity) throws IdentityStorageException {
        this.storage.saveIdentity(identity);
        IdentityKey key = new IdentityKey(new Identity(identity.getId()));
        this.exoIdentityCache.put((Serializable)key, (Object)new IdentityData(identity));
        this.exoIdentityIndexCache.put((Serializable)new IdentityCompositeKey(identity.getProviderId(), identity.getRemoteId()), (Object)key);
        this.clearCache();
    }

    @Override
    public Identity updateIdentity(Identity identity) throws IdentityStorageException {
        IdentityKey key = new IdentityKey(new Identity(identity.getId()));
        this.exoIdentityCache.remove((Serializable)key);
        this.exoProfileCache.remove((Serializable)key);
        this.exoIdentityIndexCache.remove((Serializable)key);
        this.clearCache();
        return this.storage.updateIdentity(identity);
    }

    @Override
    public void updateIdentityMembership(String remoteId) throws IdentityStorageException {
        this.clearCache();
    }

    @Override
    public Identity findIdentityById(final String nodeId) throws IdentityStorageException {
        IdentityKey key = new IdentityKey(new Identity(nodeId));
        final Identity i = ((IdentityData)this.identityCache.get(new ServiceContext<IdentityData>(){

            @Override
            public IdentityData execute() {
                return new IdentityData(CachedIdentityStorage.this.storage.findIdentityById(nodeId));
            }
        }, key)).build();
        if (i != null) {
            ProfileLoader loader = new ProfileLoader(){

                @Override
                public Profile load() throws IdentityStorageException {
                    Profile profile = new Profile(i);
                    return CachedIdentityStorage.this.loadProfile(profile);
                }
            };
            i.setProfileLoader(loader);
        }
        return i;
    }

    @Override
    public void deleteIdentity(Identity identity) throws IdentityStorageException {
        this.storage.deleteIdentity(identity);
        IdentityKey key = new IdentityKey(new Identity(identity.getId()));
        IdentityData data = (IdentityData)this.exoIdentityCache.remove((Serializable)key);
        IdentityCompositeKey compositeKey = new IdentityCompositeKey(identity.getProviderId(), identity.getRemoteId());
        if (this.exoIdentityIndexCache.get((Serializable)compositeKey) != null) {
            this.exoIdentityIndexCache.remove((Serializable)compositeKey);
        }
        this.exoProfileCache.remove((Serializable)key);
        this.clearCache();
    }

    @Override
    public void hardDeleteIdentity(Identity identity) throws IdentityStorageException {
        this.storage.hardDeleteIdentity(identity);
        IdentityKey key = new IdentityKey(new Identity(identity.getId()));
        IdentityData data = (IdentityData)this.exoIdentityCache.remove((Serializable)key);
        IdentityCompositeKey compositeKey = new IdentityCompositeKey(identity.getProviderId(), identity.getRemoteId());
        if (this.exoIdentityIndexCache.get((Serializable)compositeKey) != null) {
            this.exoIdentityIndexCache.remove((Serializable)compositeKey);
        }
        this.exoProfileCache.remove((Serializable)key);
        this.clearCache();
    }

    @Override
    public Profile loadProfile(final Profile profile) throws IdentityStorageException {
        IdentityKey key = new IdentityKey(new Identity(profile.getIdentity().getId()));
        ProfileData profileData = (ProfileData)this.profileCache.get(new ServiceContext<ProfileData>(){

            @Override
            public ProfileData execute() {
                Profile loadedProfile = CachedIdentityStorage.this.storage.loadProfile(profile);
                if (loadedProfile == null) {
                    LOG.warn((Object)("Null profile for identity: " + profile.getIdentity().getRemoteId()));
                    return ProfileData.NULL_OBJECT;
                }
                return new ProfileData(loadedProfile);
            }
        }, key);
        if (profileData == null || profileData.getProfileId() == null) {
            return profile;
        }
        return profileData.build();
    }

    public void clearIdentityCached(Identity identity, String oldRemoteId) {
        IdentityKey key = new IdentityKey(new Identity(identity.getId()));
        IdentityData data = (IdentityData)this.exoIdentityCache.remove((Serializable)key);
        IdentityCompositeKey compositeKey = new IdentityCompositeKey(identity.getProviderId(), oldRemoteId);
        if (this.exoIdentityIndexCache.get((Serializable)compositeKey) != null) {
            this.exoIdentityIndexCache.remove((Serializable)compositeKey);
        }
        this.exoProfileCache.remove((Serializable)key);
        this.clearCache();
    }

    @Override
    public Identity findIdentity(final String providerId, final String remoteId) throws IdentityStorageException {
        IdentityCompositeKey key = new IdentityCompositeKey(providerId, remoteId);
        IdentityKey k = (IdentityKey)this.identityIndexCache.get(new ServiceContext<IdentityKey>(){

            @Override
            public IdentityKey execute() {
                Identity i = CachedIdentityStorage.this.storage.findIdentity(providerId, remoteId);
                IdentityKey key = null;
                if (i == null) {
                    key = new IdentityKey(null);
                } else {
                    key = new IdentityKey(i);
                    if (CachedIdentityStorage.this.exoIdentityCache.get((Serializable)key) == null) {
                        CachedIdentityStorage.this.exoIdentityCache.putLocal((Serializable)key, (Object)new IdentityData(i));
                    }
                }
                return key;
            }
        }, key);
        if (k != null && k.getId() != null) {
            return this.findIdentityById(k.getId());
        }
        return null;
    }

    @Override
    public void saveProfile(Profile profile) throws IdentityStorageException {
        this.storage.saveProfile(profile);
        IdentityKey key = new IdentityKey(new Identity(profile.getIdentity().getId()));
        this.exoProfileCache.remove((Serializable)key);
    }

    @Override
    public void updateProfile(Profile profile) throws IdentityStorageException {
        this.storage.updateProfile(profile);
        IdentityKey key = new IdentityKey(new Identity(profile.getIdentity().getId()));
        this.exoProfileCache.remove((Serializable)key);
        this.clearCache();
    }

    @Override
    public int getIdentitiesCount(String providerId) throws IdentityStorageException {
        return this.storage.getIdentitiesCount(providerId);
    }

    @Override
    public List<Identity> getIdentitiesByProfileFilter(final String providerId, final ProfileFilter profileFilter, final long offset, final long limit, final boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        IdentityFilterKey key = new IdentityFilterKey(providerId, profileFilter);
        ListIdentitiesKey listKey = new ListIdentitiesKey(key, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.identitiesCache.get(new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List<Identity> got = CachedIdentityStorage.this.storage.getIdentitiesByProfileFilter(providerId, profileFilter, offset, limit, forceLoadOrReloadProfile);
                return CachedIdentityStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildIdentities(keys);
    }

    @Override
    public List<Identity> getIdentitiesForMentions(String providerId, ProfileFilter profileFilter, Relationship.Type type, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        return this.storage.getIdentitiesForMentions(providerId, profileFilter, type, offset, limit, forceLoadOrReloadProfile);
    }

    @Override
    public int getIdentitiesForMentionsCount(String providerId, ProfileFilter profileFilter, Relationship.Type type) throws IdentityStorageException {
        return this.storage.getIdentitiesForMentionsCount(providerId, profileFilter, type);
    }

    @Override
    public int getIdentitiesByProfileFilterCount(final String providerId, final ProfileFilter profileFilter) throws IdentityStorageException {
        IdentityFilterKey key = new IdentityFilterKey(providerId, profileFilter);
        return (Integer)((IntegerData)this.identitiesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedIdentityStorage.this.storage.getIdentitiesByProfileFilterCount(providerId, profileFilter));
            }
        }, key)).build();
    }

    @Override
    public int getIdentitiesByFirstCharacterOfNameCount(final String providerId, final ProfileFilter profileFilter) throws IdentityStorageException {
        IdentityFilterKey key = new IdentityFilterKey(providerId, profileFilter);
        return (Integer)((IntegerData)this.identitiesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedIdentityStorage.this.storage.getIdentitiesByFirstCharacterOfNameCount(providerId, profileFilter));
            }
        }, key)).build();
    }

    @Override
    public List<Identity> getIdentitiesByFirstCharacterOfName(final String providerId, final ProfileFilter profileFilter, final long offset, final long limit, final boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        IdentityFilterKey key = new IdentityFilterKey(providerId, profileFilter);
        ListIdentitiesKey listKey = new ListIdentitiesKey(key, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.identitiesCache.get(new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List<Identity> got = CachedIdentityStorage.this.storage.getIdentitiesByFirstCharacterOfName(providerId, profileFilter, offset, limit, forceLoadOrReloadProfile);
                return CachedIdentityStorage.this.buildIds(got);
            }
        }, listKey);
        LOG.trace((Object)("getIdentitiesByFirstCharacterOfName:: return " + keys.getIds().size()));
        return this.buildIdentities(keys);
    }

    @Override
    public String getType(String nodetype, String property) {
        return this.storage.getType(nodetype, property);
    }

    @Override
    public void addOrModifyProfileProperties(Profile profile) throws IdentityStorageException {
        this.storage.addOrModifyProfileProperties(profile);
    }

    @Override
    public List<Identity> getSpaceMemberIdentitiesByProfileFilter(final Space space, final ProfileFilter profileFilter, final SpaceMemberFilterListAccess.Type type, final long offset, final long limit) throws IdentityStorageException {
        SpaceKey spaceKey = new SpaceKey(space.getId());
        IdentityFilterKey identityKey = new IdentityFilterKey("space", profileFilter);
        ListSpaceMembersKey listKey = new ListSpaceMembersKey(spaceKey, identityKey, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.identitiesCache.get(new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List<Identity> got = CachedIdentityStorage.this.storage.getSpaceMemberIdentitiesByProfileFilter(space, profileFilter, type, offset, limit);
                return CachedIdentityStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildIdentities(keys);
    }

    @Override
    public void updateProfileActivityId(Identity identity, String activityId, Profile.AttachedActivityType type) {
        this.storage.updateProfileActivityId(identity, activityId, type);
        IdentityKey key = new IdentityKey(new Identity(identity.getId()));
        this.exoProfileCache.remove((Serializable)key);
        this.clearCache();
    }

    @Override
    public String getProfileActivityId(Profile profile, Profile.AttachedActivityType type) {
        return this.storage.getProfileActivityId(profile, type);
    }

    @Override
    public List<Identity> getIdentitiesForUnifiedSearch(String providerId, ProfileFilter profileFilter, long offset, long limit) throws IdentityStorageException {
        return this.storage.getIdentitiesForUnifiedSearch(providerId, profileFilter, offset, limit);
    }

    @Override
    public Set<String> getActiveUsers(final ActiveIdentityFilter filter) {
        ActiveIdentityKey key = new ActiveIdentityKey(filter);
        boolean isExistFromCache = this.activeIdentitiesCache.get(key) != null;
        ActiveIdentitiesData data = (ActiveIdentitiesData)this.activeIdentitiesCache.get(new ServiceContext<ActiveIdentitiesData>(){

            @Override
            public ActiveIdentitiesData execute() {
                Set<String> got = CachedIdentityStorage.this.storage.getActiveUsers(filter);
                return new ActiveIdentitiesData(got);
            }
        }, key);
        Object users = data.build();
        if (isExistFromCache && CommonsUtils.getService(UserStateService.class) != null) {
            List onlines = ((UserStateService)CommonsUtils.getService(UserStateService.class)).online();
            for (UserStateModel user : onlines) {
                users.add(user.getUserId());
            }
        }
        return users;
    }

    @Override
    public void processEnabledIdentity(Identity identity, boolean isEnable) {
        this.storage.processEnabledIdentity(identity, isEnable);
        IdentityKey key = new IdentityKey(new Identity(identity.getId()));
        this.exoIdentityCache.remove((Serializable)key);
        this.exoProfileCache.remove((Serializable)key);
        this.clearCache();
        this.getCachedRelationshipStorage().clearAllRelationshipCache();
    }

    @Override
    public List<IdentityWithRelationship> getIdentitiesWithRelationships(String identityId, int offset, int limit) {
        return this.storage.getIdentitiesWithRelationships(identityId, offset, limit);
    }

    @Override
    public List<IdentityWithRelationship> getIdentitiesWithRelationships(String identityId, String firstCharFieldName, char firstChar, String sortFieldName, String sortDirection, int offset, int limit) {
        return this.storage.getIdentitiesWithRelationships(identityId, firstCharFieldName, firstChar, sortFieldName, sortDirection, offset, limit);
    }

    @Override
    public int countIdentitiesWithRelationships(String identityId) throws Exception {
        return this.storage.countIdentitiesWithRelationships(identityId);
    }

    @Override
    public InputStream getAvatarInputStreamById(Identity identity) throws IOException {
        return this.storage.getAvatarInputStreamById(identity);
    }

    @Override
    public InputStream getBannerInputStreamById(Identity identity) throws IOException {
        return this.storage.getBannerInputStreamById(identity);
    }

    @Override
    public int countSpaceMemberIdentitiesByProfileFilter(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type) {
        return this.storage.countSpaceMemberIdentitiesByProfileFilter(space, profileFilter, type);
    }

    @Override
    public List<Identity> getIdentities(final String providerId, final String firstCharacterFieldName, final char firstCharacter, final String sortField, final String sortDirection, final long offset, final long limit) {
        ProfileFilter profileFilter = null;
        if (firstCharacter > '\u0000' || StringUtils.isNotBlank((CharSequence)sortField)) {
            profileFilter = new ProfileFilter();
            profileFilter.setFirstCharFieldName(firstCharacterFieldName);
            profileFilter.setFirstCharacterOfName(firstCharacter);
            profileFilter.setSorting(Sorting.valueOf(sortField, sortDirection));
        }
        IdentityFilterKey key = new IdentityFilterKey(providerId, profileFilter);
        ListIdentitiesKey listKey = new ListIdentitiesKey(key, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.identitiesCache.get(new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List<Identity> got = CachedIdentityStorage.this.storage.getIdentities(providerId, firstCharacterFieldName, firstCharacter, sortField, sortDirection, offset, limit);
                return CachedIdentityStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildIdentities(keys);
    }

    @Override
    public List<Identity> getIdentities(String providerId, long offset, long limit) {
        return this.getIdentities(providerId, null, '\u0000', null, null, offset, limit);
    }

    @Override
    public List<String> sortIdentities(List<String> identityRemoteIds, String firstCharacterFieldName, char firstCharacter, String sortField, String sortDirection) {
        return this.storage.sortIdentities(identityRemoteIds, firstCharacterFieldName, firstCharacter, sortField, sortDirection);
    }
}

