/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.selector;

import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.social.core.storage.cache.model.data.SuggestionsData;
import org.exoplatform.social.core.storage.cache.model.key.IdentityKey;
import org.exoplatform.social.core.storage.cache.model.key.ScopeCacheKey;
import org.exoplatform.social.core.storage.cache.model.key.SuggestionKey;
import org.exoplatform.social.core.storage.cache.selector.ScopeCacheSelector;

public class SuggestionCacheSelector
extends ScopeCacheSelector<ScopeCacheKey, Object> {
    private String[] target;

    public SuggestionCacheSelector(String ... target) {
        this.target = target;
    }

    @Override
    public boolean select(ScopeCacheKey key, ObjectCacheInfo<? extends Object> ocinfo) {
        if (!super.select(key, ocinfo)) {
            return false;
        }
        if (key instanceof SuggestionKey) {
            return this.select((SuggestionKey)key, ocinfo);
        }
        return false;
    }

    @Override
    private boolean select(SuggestionKey key, ObjectCacheInfo<? extends Object> ocinfo) {
        if (key.getKey() instanceof IdentityKey) {
            String id = ((IdentityKey)key.getKey()).getId();
            for (String i : this.target) {
                if (!id.equals(i)) continue;
                return true;
            }
            if (ocinfo == null) {
                return true;
            }
            Object value = ocinfo.get();
            if (value instanceof SuggestionsData) {
                SuggestionsData data = (SuggestionsData)value;
                if (data.getMap() == null) {
                    return false;
                }
                for (String i : this.target) {
                    if (!data.getMap().containsKey(i)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

