/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.streams;

import java.io.Serializable;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;

public class StreamConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int CONNECTIONS_THRESHOLD = 1000;
    private static final int LAST_LOGIN_AROUND_DAYS = 30;
    private final String CONNECTIONS_THRESHOLD_PARAMS = "connections-threshold-param";
    private final String LAST_LOGIN_AROUND_DAYS_PARAMS = "last-login-around-days";
    private final String LIMIT_PER_LOADING_PARAMS = "limit-per-loading-param";
    private final String ACTIVE_USER_GROUPS_PARAMS = "active-user-groups-param";
    private int connectionsThreshold = -1;
    private int lastLoginAroundDays = -1;
    private int limitThresholdLoading = 10;
    private String activeUserGroups = null;

    public StreamConfig(InitParams params) {
        ValueParam connectionsThresholdParam = params.getValueParam("connections-threshold-param");
        ValueParam lastLoginAroundDaysParam = params.getValueParam("last-login-around-days");
        ValueParam limitPerLoadingParam = params.getValueParam("limit-per-loading-param");
        ValueParam activeUserGroupsParam = params.getValueParam("active-user-groups-param");
        if (connectionsThresholdParam != null) {
            try {
                this.connectionsThreshold = Integer.valueOf(connectionsThresholdParam.getValue());
            }
            catch (Exception e) {
                this.connectionsThreshold = 1000;
            }
        }
        if (lastLoginAroundDaysParam != null) {
            try {
                this.lastLoginAroundDays = Integer.valueOf(lastLoginAroundDaysParam.getValue());
            }
            catch (Exception e) {
                this.lastLoginAroundDays = 30;
            }
        }
        if (limitPerLoadingParam != null) {
            try {
                this.limitThresholdLoading = Integer.valueOf(limitPerLoadingParam.getValue());
            }
            catch (Exception e) {
                this.limitThresholdLoading = 10;
            }
        }
        if (activeUserGroupsParam != null) {
            try {
                this.activeUserGroups = activeUserGroupsParam.getValue();
            }
            catch (Exception e) {
                this.activeUserGroups = null;
            }
        }
    }

    public int getConnectionsThreshold() {
        return this.connectionsThreshold;
    }

    public int getLastLoginAroundDays() {
        return this.lastLoginAroundDays;
    }

    public int getLimitThresholdLoading() {
        return this.limitThresholdLoading;
    }

    public String getActiveUserGroups() {
        return this.activeUserGroups;
    }
}

