/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.streams;

import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.service.AsyncProcessor;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.common.service.Processor;
import org.exoplatform.social.common.service.SocialServiceContext;
import org.exoplatform.social.common.service.impl.SocialServiceContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.chromattic.entity.ActivityEntity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.streams.StreamProcessContext;
import org.exoplatform.social.core.storage.streams.StreamProcessorFactory;

public class StreamInvocationHelper {
    private static final Log LOG = ExoLogger.getLogger(StreamInvocationHelper.class);
    private static SocialServiceContext ctx = SocialServiceContextImpl.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext save(Identity owner, ActivityEntity entity, String[] mentioners) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.NEW_ACTIVITY_RELATIONS_PROCESS, ctx);
        processCtx.identity(owner).activityEntity(entity).posterId(entity.getPosterIdentity().getId()).mentioners(mentioners);
        try {
            if (ctx.isAsync()) {
                ctx.getServiceExecutor().async((AsyncProcessor)StreamProcessorFactory.saveStream(), (ProcessContext)processCtx);
            } else {
                ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.saveStream(), (ProcessContext)processCtx);
            }
        }
        finally {
            if (ctx.isTraced()) {
                LOG.debug((Object)processCtx.getTraceLog());
            }
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext savePoster(Identity owner, ActivityEntity entity) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.NEW_ACTIVITY_PROCESS, ctx);
        processCtx.identity(owner).activityEntity(entity);
        try {
            ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.savePoster(), (ProcessContext)processCtx);
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    private static boolean beforeAsync() {
        if (ctx.isAsync()) {
            return StorageUtils.persist();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext update(ExoSocialActivity activity, long oldUpdated) {
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.UPDATE_ACTIVITY_PROCESS, ctx);
        processCtx.activity(activity).oldLastUpdated(oldUpdated);
        try {
            if (ctx.isAsync()) {
                processCtx.getTraceElement().start();
                StreamInvocationHelper.beforeAsync();
                ctx.getServiceExecutor().async((AsyncProcessor)StreamProcessorFactory.updateStream(), (ProcessContext)processCtx);
                processCtx.getTraceElement().end();
            } else {
                ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.updateStream(), (ProcessContext)processCtx);
            }
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext updateHidable(Identity owner, ActivityEntity entity, ExoSocialActivity activity) {
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.UPDATE_ACTIVITY_REF, ctx);
        processCtx.activity(activity).mentioners(entity.getMentioners()).identity(owner);
        try {
            if (ctx.isAsync()) {
                StreamInvocationHelper.beforeAsync();
                ctx.getServiceExecutor().async((AsyncProcessor)StreamProcessorFactory.updateHidable(), (ProcessContext)processCtx);
            } else {
                ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.updateHidable(), (ProcessContext)processCtx);
            }
        }
        finally {
            if (ctx.isTraced()) {
                LOG.debug((Object)processCtx.getTraceLog());
            }
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext updateCommenter(Identity commenter, ActivityEntity entity, String[] commenters, long oldUpdated) {
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.UPDATE_ACTIVITY_COMMENTER_PROCESS, ctx);
        processCtx.identity(commenter).activityEntity(entity).commenters(commenters).oldLastUpdated(oldUpdated);
        try {
            ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.updateCommenter(), (ProcessContext)processCtx);
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext deleteComment(ExoSocialActivity activity, String[] mentioners, String[] commenters) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.DELETE_COMMENT_PROCESS, ctx);
        processCtx.activity(activity).mentioners(mentioners).commenters(commenters);
        try {
            ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.deleteCommentStream(), (ProcessContext)processCtx);
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext unLike(Identity removedLike, ExoSocialActivity activity) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.UNLIKE_ACTIVITY_PROCESS, ctx);
        processCtx.identity(removedLike).activity(activity);
        try {
            ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.unlikeActivity(), (ProcessContext)processCtx);
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext like(Identity liker, ExoSocialActivity activity) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.LIKE_ACTIVITY_PROCESS, ctx);
        processCtx.identity(liker).activity(activity);
        try {
            ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.likeActivity(), (ProcessContext)processCtx);
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext deleteConnect(Identity sender, Identity receiver) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.DELETE_CONNECT_ACTIVITY_PROCESS, ctx);
        processCtx.sender(sender).receiver(receiver);
        try {
            ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.deleteConnectStream(), (ProcessContext)processCtx);
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext connect(Identity sender, Identity receiver) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.CONNECT_ACTIVITY_PROCESS, ctx);
        processCtx.sender(sender).receiver(receiver);
        try {
            if (ctx.isAsync()) {
                StreamInvocationHelper.beforeAsync();
                ctx.getServiceExecutor().async((AsyncProcessor)StreamProcessorFactory.connectStream(), (ProcessContext)processCtx);
            } else {
                ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.connectStream(), (ProcessContext)processCtx);
            }
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext addSpaceMember(Identity owner, Identity spaceIdentity) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.ADD_SPACE_MEMBER_ACTIVITY_PROCESS, ctx);
        processCtx.identity(owner).spaceIdentity(spaceIdentity);
        try {
            ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.addSpaceMemberStream(), (ProcessContext)processCtx);
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext removeSpaceMember(Identity owner, Identity spaceIdentity) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.REMOVE_SPACE_MEMBER_ACTIVITY_PROCESS, ctx);
        processCtx.identity(owner).spaceIdentity(spaceIdentity);
        try {
            ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.removeSpaceMemberStream(), (ProcessContext)processCtx);
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext createFeedActivityRef(Identity owner, List<ExoSocialActivity> list) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.LAZY_UPGRADE_STREAM_PROCESS, ctx);
        processCtx.identity(owner).activities(list);
        try {
            if (ctx.isAsync()) {
                StreamInvocationHelper.beforeAsync();
                ctx.getServiceExecutor().async((AsyncProcessor)StreamProcessorFactory.createFeedActivityRef(), (ProcessContext)processCtx);
            } else {
                ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.createFeedActivityRef(), (ProcessContext)processCtx);
            }
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext createFeedActivityRefSynchronous(Identity owner, List<ExoSocialActivity> list) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.LAZY_UPGRADE_STREAM_PROCESS, ctx);
        processCtx.identity(owner).activities(list);
        try {
            ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.createFeedActivityRef(), (ProcessContext)processCtx);
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext createConnectionsActivityRef(Identity owner, List<ExoSocialActivity> list) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.LAZY_UPGRADE_STREAM_PROCESS, ctx);
        processCtx.identity(owner).activities(list);
        try {
            if (ctx.isAsync()) {
                StreamInvocationHelper.beforeAsync();
                ctx.getServiceExecutor().async((AsyncProcessor)StreamProcessorFactory.createConnectionsActivityRef(), (ProcessContext)processCtx);
            } else {
                ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.createConnectionsActivityRef(), (ProcessContext)processCtx);
            }
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext createConnectionsActivityRefSynchronous(Identity owner, List<ExoSocialActivity> list) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.LAZY_UPGRADE_STREAM_PROCESS, ctx);
        processCtx.identity(owner).activities(list);
        try {
            ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.createConnectionsActivityRef(), (ProcessContext)processCtx);
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext createMySpacesActivityRef(Identity owner, List<ExoSocialActivity> list) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.LAZY_UPGRADE_STREAM_PROCESS, ctx);
        processCtx.identity(owner).activities(list);
        try {
            if (ctx.isAsync()) {
                StreamInvocationHelper.beforeAsync();
                ctx.getServiceExecutor().async((AsyncProcessor)StreamProcessorFactory.createMySpacesActivityRef(), (ProcessContext)processCtx);
            } else {
                ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.createMySpacesActivityRef(), (ProcessContext)processCtx);
            }
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext createMyActivitiesActivityRef(Identity owner, List<ExoSocialActivity> list) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.LAZY_UPGRADE_STREAM_PROCESS, ctx);
        processCtx.identity(owner).activities(list);
        try {
            if (ctx.isAsync()) {
                processCtx.getTraceElement().start();
                StreamInvocationHelper.beforeAsync();
                ctx.getServiceExecutor().async((AsyncProcessor)StreamProcessorFactory.createMyActivitiesActivityRef(), (ProcessContext)processCtx);
                processCtx.getTraceElement().end();
            } else {
                ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.createMyActivitiesActivityRef(), (ProcessContext)processCtx);
            }
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessContext createSpaceActivityRef(Identity owner, List<ExoSocialActivity> list) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.LAZY_UPGRADE_STREAM_PROCESS, ctx);
        processCtx.identity(owner).activities(list);
        try {
            if (ctx.isAsync()) {
                StreamInvocationHelper.beforeAsync();
                ctx.getServiceExecutor().async((AsyncProcessor)StreamProcessorFactory.createSpaceActivityRef(), (ProcessContext)processCtx);
            } else {
                ctx.getServiceExecutor().execute((Processor)StreamProcessorFactory.createSpaceActivityRef(), (ProcessContext)processCtx);
            }
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    public static ProcessContext loadFeed(Identity owner) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.LOAD_ACTIVITIES_STREAM_PROCESS, ctx);
        processCtx.identity(owner);
        try {
            processCtx.getTraceElement().start();
            ctx.getServiceExecutor().async((AsyncProcessor)StreamProcessorFactory.loadFeed(), (ProcessContext)processCtx);
            processCtx.getTraceElement().end();
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }

    public static ProcessContext addMentioners(ExoSocialActivity activity, String[] mentioners) {
        StreamProcessContext processCtx = StreamProcessContext.getIntance(StreamProcessContext.UPDATE_ACTIVITY_MENTIONER_PROCESS, ctx);
        processCtx.activity(activity).mentioners(mentioners);
        try {
            processCtx.getTraceElement().start();
            ctx.getServiceExecutor().async((AsyncProcessor)StreamProcessorFactory.addMentioners(), (ProcessContext)processCtx);
            processCtx.getTraceElement().end();
        }
        finally {
            LOG.debug((Object)processCtx.getTraceLog());
        }
        return processCtx;
    }
}

