/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.updater;

import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.updater.SpaceActivityStreamMigration;

public class SpaceActivityStreamUpdaterPlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(SpaceActivityStreamUpdaterPlugin.class);
    private SpaceActivityStreamMigration streamMigration = null;
    public int limit = -1;

    public SpaceActivityStreamUpdaterPlugin(InitParams initParams) {
        super(initParams);
        if (initParams.containsKey((Object)"limit")) {
            try {
                String value = initParams.getValueParam("limit").getValue();
                if (value != null) {
                    this.limit = Integer.valueOf(value);
                }
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Integer number expected for property " + this.name));
            }
        }
    }

    private SpaceActivityStreamMigration getStreamMigration() {
        if (this.streamMigration == null) {
            this.streamMigration = (SpaceActivityStreamMigration)((Object)PortalContainer.getInstance().getComponentInstanceOfType(SpaceActivityStreamMigration.class));
        }
        return this.streamMigration;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        this.getStreamMigration().upgrade(this.limit);
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

