/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search;

import java.util.concurrent.CompletableFuture;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.search.index.IndexingOperationProcessor;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.SystemSearchManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.wcm.search.FileESMigration$AjcClosure1;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.quartz.InterruptableJob;
import org.quartz.UnableToInterruptJobException;

public class FileESMigration
extends UpgradeProductPlugin {
    private static final Log LOG;
    public static final String FILE_ES_INDEXATION_KEY = "FILE_ES_INDEXATION";
    public static final String FILE_ES_INDEXATION_DONE_KEY = "FILE_ES_INDEXATION_DONE";
    public static final String FILE_JCR_COLLABORATION_REINDEXATION_DONE_KEY = "FILE_JCR_COLLABORATION_REINDEXATION_DONE";
    public static final String FILE_JCR_SYSTEM_REINDEXATION_DONE_KEY = "FILE_JCR_SYSTEM_REINDEXATION_DONE";
    private IndexingService indexingService;
    private SettingService settingService;
    private RepositoryService repositoryService;
    private IndexingOperationProcessor indexingOperationProcessor;
    private JobSchedulerService jobSchedulerService;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public FileESMigration(InitParams initParams, IndexingService indexingService, SettingService settingService, RepositoryService repositoryService, IndexingOperationProcessor indexingOperationProcessor, JobSchedulerService jobSchedulerService) {
        super(initParams);
        this.indexingService = indexingService;
        this.settingService = settingService;
        this.repositoryService = repositoryService;
        this.indexingOperationProcessor = indexingOperationProcessor;
        this.jobSchedulerService = jobSchedulerService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        try {
            if (!this.isIndexationInESDone()) {
                this.printNumberOfFileToIndex();
                this.indexInES();
            }
            if (!this.isJCRReindexationDone()) {
                this.reindexJCR();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while Files indexing in ES migration", e);
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return !this.isIndexationInESDone() || !this.isJCRReindexationDone();
    }

    public void reindexJCR() throws Exception {
        try {
            SearchManager searchManager = (SearchManager)this.repositoryService.getCurrentRepository().getWorkspaceContainer("collaboration").getComponent(SearchManager.class);
            if (!this.isJCRCollaboraionReindexationDone()) {
                LOG.info((Object)"== Files ES migration - Starting reindexation of JCR collaboration workspace");
                CompletableFuture reindexCollaborationWSResult = searchManager.reindexWorkspace(false, 0);
                reindexCollaborationWSResult.thenAccept(successful -> {
                    if (successful.booleanValue()) {
                        LOG.info((Object)"== Files ES migration - Reindexation of JCR collaboration workspace done");
                        this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(FILE_ES_INDEXATION_KEY), FILE_JCR_COLLABORATION_REINDEXATION_DONE_KEY, SettingValue.create((Boolean)true));
                    } else {
                        LOG.error((Object)"== Files ES migration - Reindexation of JCR collaboration workspace failed. Check logs to fix the issue, then reindex it by restarting the server");
                    }
                });
            }
            if (!this.isJCRSystemReindexationDone()) {
                LOG.info((Object)"== Files ES migration - Starting reindexation of JCR system workspace");
                SystemSearchManager systemSearchManager = (SystemSearchManager)this.repositoryService.getCurrentRepository().getWorkspaceContainer("system").getComponent(SystemSearchManager.class);
                CompletableFuture reindexSystemWSResult = systemSearchManager.reindexWorkspace(false, 0);
                reindexSystemWSResult.thenAccept(successful -> {
                    if (successful.booleanValue()) {
                        LOG.info((Object)"== Files ES migration - Reindexation of JCR system workspace done");
                        this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(FILE_ES_INDEXATION_KEY), FILE_JCR_SYSTEM_REINDEXATION_DONE_KEY, SettingValue.create((Boolean)true));
                    } else {
                        LOG.error((Object)"== Files ES migration - Reindexation of JCR system workspace failed. Check logs to fix the issue, then reindex it by restarting the server");
                    }
                });
            }
        }
        catch (RepositoryException e) {
            throw new Exception("Error while reindexing JCR collaboration and system workspaces", e);
        }
    }

    public void indexInES() throws Exception {
        LOG.info((Object)"== Files ES migration - Pause ESBulkIndexer job");
        this.jobSchedulerService.pauseJob("ESBulkIndexer", "ElasticSearch");
        try {
            LOG.info((Object)"== Files ES migration - Stopping executing jobs ESBulkIndexer instances...");
            this.jobSchedulerService.getAllExcutingJobs().stream().filter(jobExecutionContext -> jobExecutionContext.getJobDetail().getKey().getName().equals("ESBulkIndexer")).forEach(indexingJob -> {
                try {
                    LOG.info((Object)("== Files ES migration - Interrupting executing job ESBulkIndexer instance " + indexingJob.getFireInstanceId()));
                    ((InterruptableJob)indexingJob.getJobInstance()).interrupt();
                }
                catch (UnableToInterruptJobException e) {
                    LOG.error((Object)"Error while interrupting ES indexing queue job to run the migration", (Throwable)e);
                }
            });
            LOG.info((Object)"== Files ES migration - Clear indexing queue for files");
            this.indexingService.clearQueue("file");
            LOG.info((Object)"== Files ES migration - Starting pushing all files in indexation queue");
            this.indexingService.reindexAll("file");
            this.processIndexation();
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(FILE_ES_INDEXATION_KEY), FILE_ES_INDEXATION_DONE_KEY, SettingValue.create((Boolean)true));
            LOG.info((Object)"== Files ES migration - Push of all files in indexation queue done");
        }
        catch (Exception e) {
            throw new Exception("Error while indexing files in ES", e);
        }
        finally {
            LOG.info((Object)"== Files ES migration - Resume ESBulkIndexer job");
            this.jobSchedulerService.resumeJob("ESBulkIndexer", "ElasticSearch");
        }
    }

    @ExoTransactional
    public void processIndexation() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new FileESMigration$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private boolean isIndexationInESDone() {
        SettingValue done = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(FILE_ES_INDEXATION_KEY), FILE_ES_INDEXATION_DONE_KEY);
        return done != null && done.getValue().equals("true");
    }

    private boolean isJCRReindexationDone() {
        return this.isJCRCollaboraionReindexationDone() && this.isJCRSystemReindexationDone();
    }

    private boolean isJCRCollaboraionReindexationDone() {
        SettingValue done = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(FILE_ES_INDEXATION_KEY), FILE_JCR_COLLABORATION_REINDEXATION_DONE_KEY);
        return done != null && done.getValue().equals("true");
    }

    private boolean isJCRSystemReindexationDone() {
        SettingValue done = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(FILE_ES_INDEXATION_KEY), FILE_JCR_SYSTEM_REINDEXATION_DONE_KEY);
        return done != null && done.getValue().equals("true");
    }

    private void printNumberOfFileToIndex() {
        try {
            Session session = WCMCoreUtils.getSystemSessionProvider().getSession("collaboration", this.repositoryService.getCurrentRepository());
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery("select * from nt:file", "sql");
            QueryResult result = query.execute();
            LOG.info((Object)("== Files ES migration - Number of files to index : " + result.getNodes().getSize()));
        }
        catch (RepositoryException e) {
            LOG.error((Object)"== Files ES migration - Error while counting all nt:file to index", (Throwable)e);
        }
    }

    static {
        FileESMigration.ajc$preClinit();
        LOG = ExoLogger.getLogger(FileESMigration.class);
    }

    static /* synthetic */ void processIndexation_aroundBody0(FileESMigration ajc$this, JoinPoint joinPoint) {
        LOG.info((Object)"== Files ES migration - Process files");
        ajc$this.indexingOperationProcessor.process();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FileESMigration.java", FileESMigration.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "processIndexation", "org.exoplatform.services.wcm.search.FileESMigration", "", "", "", "void"), 173);
    }
}

