/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.operations.site;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.exoplatform.portal.mop.management.operations.AbstractMopOperationHandler;
import org.gatein.management.api.exceptions.OperationException;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.api.operation.ResultHandler;
import org.gatein.management.api.operation.model.ReadResourceModel;
import org.gatein.mop.api.workspace.Navigation;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Page;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;

public class SiteTypeReadResource
extends AbstractMopOperationHandler {
    @Override
    protected void execute(OperationContext operationContext, ResultHandler resultHandler, Workspace workspace, ObjectType<Site> siteType) throws ResourceNotFoundException, OperationException {
        Collection sites = workspace.getSites(siteType);
        LinkedHashSet<String> children = new LinkedHashSet<String>(sites.size());
        for (Site site : sites) {
            if (siteType == ObjectType.GROUP_SITE) {
                String name;
                Navigation defaultNav;
                boolean pageOrNav = false;
                Page pages = site.getRootPage().getChild("pages");
                if (pages != null && !pages.getChildren().isEmpty()) {
                    pageOrNav = true;
                }
                if ((defaultNav = site.getRootNavigation().getChild("default")) != null && !defaultNav.getChildren().isEmpty()) {
                    pageOrNav = true;
                }
                if ((name = site.getName()).charAt(0) != '/' || !pageOrNav) continue;
                children.add(site.getName());
                continue;
            }
            children.add(site.getName());
        }
        resultHandler.completed((Object)new ReadResourceModel("Available sites for site type '" + this.getSiteType(siteType).getName() + "'", children));
    }
}

