/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.page;

import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.page.PageData;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.pom.config.POMSession;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Page;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;

abstract class DataCache {
    DataCache() {
    }

    protected abstract PageData getPage(POMSession var1, PageKey var2);

    protected abstract void removePage(POMSession var1, PageKey var2);

    protected abstract void putPage(PageData var1);

    protected abstract void clear();

    final PageData getPageData(POMSession session, PageKey key) {
        PageData data = session.isModified() ? this.loadPage(session, key) : this.getPage(session, key);
        return data;
    }

    protected final PageData loadPage(POMSession session, PageKey key) {
        ObjectType<Site> objectType;
        Workspace workspace = session.getWorkspace();
        Site site = workspace.getSite(objectType = Utils.objectType(key.getSite().getType()), key.getSite().getName());
        if (site != null) {
            Page root = site.getRootPage();
            Page pages = root.getChild("pages");
            Page page = pages.getChild(key.getName());
            if (page != null) {
                return new PageData(page);
            }
            return PageData.EMPTY;
        }
        return PageData.EMPTY;
    }
}

