/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.embedder;

import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.embedder.AbstractEmbedder;
import org.exoplatform.commons.embedder.ExoMedia;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class YoutubeEmbedder
extends AbstractEmbedder {
    private static final Log LOG = ExoLogger.getLogger(YoutubeEmbedder.class);
    private static final Pattern YOUTUBE_ID_PATTERN = Pattern.compile("(youtu\\.be\\/|youtube\\.com\\/(watch\\?(.*&)?v=|(embed|v)\\/))([^\\?&\"'>]+)");
    private static final String YOUTUBE_SRC = "//www.youtube.com/embed/%s?enablejsapi=1";
    private static final String YOUTUBE_V3_API_KEY_PROPERTY = "youtube.v3.api.key";

    public YoutubeEmbedder(InitParams initParams) {
        super(initParams);
    }

    public Pattern getYouTubeURLPattern() {
        return this.getPattern();
    }

    @Override
    public ExoMedia getExoMedia() {
        String feedsURL = null;
        String scheme = "http";
        for (Pattern pattern : this.schemeEndpointMap.keySet()) {
            Matcher matcher = pattern.matcher(this.url);
            if (matcher.find()) {
                feedsURL = (String)this.schemeEndpointMap.get(pattern);
                try {
                    PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
                    scheme = portalRequestContext.getRequest().getScheme();
                }
                catch (Exception e) {
                    LOG.info((Object)"Cannot get scheme from Portal Request Context");
                }
                continue;
            }
            return null;
        }
        String youtubeV3APIKey = System.getProperty(YOUTUBE_V3_API_KEY_PROPERTY);
        try {
            Matcher matcher = YOUTUBE_ID_PATTERN.matcher(this.url);
            String youtubeId = null;
            while (matcher.find()) {
                youtubeId = matcher.group(5);
            }
            String html = this.buildIFramePlayer(youtubeId, scheme);
            if (html == null) {
                return null;
            }
            ExoMedia mediaObject = new ExoMedia();
            mediaObject.setHtml(html);
            if (youtubeV3APIKey == null || youtubeV3APIKey.length() == 0) {
                mediaObject.setTitle(this.url);
                mediaObject.setDescription(this.url);
                return mediaObject;
            }
            String youTubeFeedURL = String.format(feedsURL, youtubeV3APIKey, youtubeId);
            URL reqURL = new URL(this.correctURIString(youTubeFeedURL, scheme, false));
            JSONObject jsonObject = this.getJSONObject(reqURL);
            JSONObject snippetObject = jsonObject.getJSONArray("items").getJSONObject(0).getJSONObject("snippet");
            String title = snippetObject.getString("title");
            String description = "";
            if (snippetObject.has("description")) {
                description = snippetObject.getString("description");
            }
            String thumbnailURL = "";
            String thumbnailWidth = "";
            String thumbnailHeight = "";
            if (snippetObject.has("thumbnails")) {
                JSONObject thumbnails = snippetObject.getJSONObject("thumbnails").getJSONObject("medium");
                thumbnailURL = thumbnails.getString("url");
                thumbnailWidth = thumbnails.getString("width");
                thumbnailHeight = thumbnails.getString("height");
            }
            mediaObject.setTitle(title);
            mediaObject.setDescription(description);
            mediaObject.setThumbnailUrl(thumbnailURL);
            mediaObject.setThumbnailHeight(thumbnailHeight);
            mediaObject.setThumbnailWidth(thumbnailWidth);
            return mediaObject;
        }
        catch (JSONException e) {
            LOG.debug((Object)"Any syntax error cause to JSON exception.", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.debug((Object)"Problem with IO when open url.", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.debug((Object)"Problem occurred when get data from youtube link.", (Throwable)e);
            return null;
        }
    }

    private String buildIFramePlayer(String youtubeId, String scheme) throws JSONException {
        if (youtubeId == null) {
            LOG.info((Object)"Returned content url not match the pattern to get content source.");
            return null;
        }
        String youTubeSRC = String.format(YOUTUBE_SRC, youtubeId);
        StringBuilder contentURL = new StringBuilder();
        contentURL.append("<iframe id=\"player\" type=\"text/html\" width=\"330\" height=\"200\" frameborder=\"0\" allowfullscreen=\"true\"").append(" src=\"").append(this.correctURIString(youTubeSRC, scheme, false)).append("\">").append("&nbsp;</iframe>");
        return contentURL.toString();
    }

    @Override
    protected Log getExoLogger() {
        return LOG;
    }
}

