/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xml.internal.parser;

import javanet.staxutils.XMLEventStreamWriter;
import javanet.staxutils.XMLStreamUtils;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import org.xml.sax.ContentHandler;
import org.xwiki.component.annotation.Component;
import org.xwiki.filter.FilterDescriptorManager;
import org.xwiki.filter.xml.XMLConfiguration;
import org.xwiki.filter.xml.internal.parameter.ParameterManager;
import org.xwiki.filter.xml.internal.parser.DefaultXMLParser;
import org.xwiki.filter.xml.parser.XMLParserFactory;
import org.xwiki.properties.ConverterManager;
import org.xwiki.xml.stax.SAXEventWriter;

@Component
@Singleton
public class DefaultXMLParserFactory
implements XMLParserFactory {
    @Inject
    private ParameterManager parameterManager;
    @Inject
    private FilterDescriptorManager descriptorManager;
    @Inject
    private ConverterManager converter;

    private ContentHandler createParser(Object filter, XMLConfiguration configuration) {
        return new DefaultXMLParser(filter, this.descriptorManager.getFilterDescriptor(new Class[]{filter.getClass()}), this.converter, this.parameterManager, configuration);
    }

    @Override
    public void parse(Source source, Object filter, XMLConfiguration configuration) throws XMLStreamException {
        if (source instanceof StAXSource) {
            StAXSource staxSource = (StAXSource)source;
            if (staxSource.getXMLEventReader() != null) {
                XMLStreamUtils.copy((XMLEventReader)staxSource.getXMLEventReader(), (XMLEventWriter)this.createXMLEventWriter(filter, configuration));
            } else {
                XMLStreamUtils.copy((XMLStreamReader)staxSource.getXMLStreamReader(), (XMLStreamWriter)new XMLEventStreamWriter(this.createXMLEventWriter(filter, configuration)));
            }
        } else {
            XMLStreamUtils.copy((Source)source, (XMLEventWriter)this.createXMLEventWriter(filter, configuration));
        }
    }

    @Override
    public Result createResult(Object filter, XMLConfiguration configuration) {
        return new StAXResult(this.createXMLEventWriter(filter, configuration));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Object filter, XMLConfiguration configuration) {
        return new SAXEventWriter(this.createParser(filter, configuration));
    }

    @Override
    public ContentHandler createContentHandler(Object filter, XMLConfiguration configuration) {
        return this.createParser(filter, configuration);
    }
}

