/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.analyzer;

import java.io.IOException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class UnescapeHTMLFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

    public UnescapeHTMLFilter(TokenStream input) {
        super(input);
    }

    public final boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] buffer = this.termAtt.buffer();
        int bufferLength = this.termAtt.length();
        String tokenText = new String(buffer);
        tokenText = tokenText.replaceAll("<br", "");
        tokenText = StringEscapeUtils.unescapeHtml((String)tokenText);
        int newLen = (tokenText = tokenText.replaceAll("\\<.*?>", "")).toCharArray().length;
        if (newLen < bufferLength) {
            this.termAtt.copyBuffer(tokenText.toCharArray(), 0, newLen);
            this.termAtt.setLength(newLen);
        }
        return true;
    }
}

