/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clipboard.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.clipboard.ClipboardService;
import org.exoplatform.services.cms.clipboard.jcr.model.ClipboardCommand;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class ClipboardServiceImpl
implements ClipboardService {
    private static final Log LOG = ExoLogger.getLogger((String)ClipboardServiceImpl.class.getName());
    private static final String CLIPBOARD_CACHE = "ecms.ClipboardServiceCache";
    private static final String CLIPBOARD_CACHE_VIRTUAL = "ecms.ClipboardServiceCacheVirtual";
    private CacheService cacheService_;
    private Map<String, Map<String, ClipboardCommand>> repoLastCommand_;
    private int liveTime_;
    private int maxSize_;

    public ClipboardServiceImpl(CacheService cacheService, InitParams initParams) {
        this.cacheService_ = cacheService;
        this.repoLastCommand_ = new HashMap<String, Map<String, ClipboardCommand>>();
        this.liveTime_ = Integer.parseInt(initParams.getValueParam("liveTime").getValue());
        this.maxSize_ = Integer.parseInt(initParams.getValueParam("maxSize").getValue());
    }

    @Override
    public void addClipboardCommand(String userId, ClipboardCommand command, boolean isVirtual) {
        ExoCache<String, Set<ClipboardCommand>> virtualCache_ = this.getVirtualCache();
        ExoCache<String, Set<ClipboardCommand>> cache_ = this.getCache();
        Map<String, ClipboardCommand> lastCommand_ = this.getLastCommandMap();
        ExoCache<String, Set<ClipboardCommand>> cache = isVirtual ? virtualCache_ : cache_;
        LinkedHashSet<ClipboardCommand> commands = (LinkedHashSet<ClipboardCommand>)cache.get((Serializable)((Object)userId));
        if (commands != null) {
            commands.add(command);
        } else {
            commands = new LinkedHashSet<ClipboardCommand>();
            commands.add(command);
            cache.put((Serializable)((Object)userId), commands);
        }
        if (!isVirtual) {
            lastCommand_.put(userId, command);
        }
    }

    @Override
    public ClipboardCommand getLastClipboard(String userId) {
        Map<String, ClipboardCommand> lastCommand_ = this.getLastCommandMap();
        return lastCommand_.get(userId);
    }

    @Override
    public Set<ClipboardCommand> getClipboardList(String userId, boolean isVirtual) {
        ExoCache<String, Set<ClipboardCommand>> virtualCache_ = this.getVirtualCache();
        ExoCache<String, Set<ClipboardCommand>> cache_ = this.getCache();
        ExoCache<String, Set<ClipboardCommand>> cache = isVirtual ? virtualCache_ : cache_;
        Set ret = (Set)cache.get((Serializable)((Object)userId));
        boolean isUpdate = false;
        Map<String, ClipboardCommand> lastCommandMap = this.getLastCommandMap();
        ClipboardCommand cmd = lastCommandMap.get(userId);
        if (ret != null) {
            HashSet<ClipboardCommand> removedCommands = new HashSet<ClipboardCommand>();
            for (ClipboardCommand command : ret) {
                if (this.isExistingNode(command)) continue;
                removedCommands.add(command);
                if (!command.equals(cmd)) continue;
                isUpdate = true;
            }
            ret.removeAll(removedCommands);
            if (isUpdate) {
                ClipboardCommand newLastCommand = null;
                Iterator iterator = ret.iterator();
                while (iterator.hasNext()) {
                    ClipboardCommand command;
                    newLastCommand = command = (ClipboardCommand)iterator.next();
                }
                lastCommandMap.put(userId, newLastCommand);
            }
            return new LinkedHashSet<ClipboardCommand>(ret);
        }
        return new LinkedHashSet<ClipboardCommand>();
    }

    @Override
    public void clearClipboardList(String userId, boolean isVirtual) {
        ExoCache<String, Set<ClipboardCommand>> virtualCache_ = this.getVirtualCache();
        ExoCache<String, Set<ClipboardCommand>> cache_ = this.getCache();
        Map<String, ClipboardCommand> lastCommand_ = this.getLastCommandMap();
        ExoCache<String, Set<ClipboardCommand>> cache = isVirtual ? virtualCache_ : cache_;
        Set commands = (Set)cache.get((Serializable)((Object)userId));
        if (commands != null) {
            commands.clear();
        }
        lastCommand_.remove(userId);
    }

    private ExoCache<String, Set<ClipboardCommand>> getVirtualCache() {
        ExoCache ret = this.cacheService_.getCacheInstance(CLIPBOARD_CACHE_VIRTUAL + this.getRepoName());
        ret.setLiveTime((long)this.liveTime_);
        ret.setMaxSize(this.maxSize_);
        return ret;
    }

    private ExoCache<String, Set<ClipboardCommand>> getCache() {
        ExoCache ret = this.cacheService_.getCacheInstance(CLIPBOARD_CACHE + this.getRepoName());
        ret.setLiveTime((long)this.liveTime_);
        ret.setMaxSize(this.maxSize_);
        return ret;
    }

    private Map<String, ClipboardCommand> getLastCommandMap() {
        Map<String, ClipboardCommand> ret = this.repoLastCommand_.get(this.getRepoName());
        if (ret == null) {
            ret = new HashMap<String, ClipboardCommand>();
            this.repoLastCommand_.put(this.getRepoName(), ret);
        }
        return ret;
    }

    private String getRepoName() {
        return WCMCoreUtils.getRepository().getConfiguration().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExistingNode(ClipboardCommand command) {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        String wsName = command.getWorkspace();
        String nodePath = command.getSrcPath();
        try {
            sessionProvider.getSession(wsName, WCMCoreUtils.getRepository()).getItem(nodePath);
        }
        catch (PathNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (RepositoryException re) {
            LOG.debug((Object)"problem while checking the existing of Node");
        }
        finally {
            sessionProvider.close();
        }
        return true;
    }

    @Override
    public void removeClipboardCommand(String userId, ClipboardCommand command) {
        ExoCache<String, Set<ClipboardCommand>> virtualCache_ = this.getVirtualCache();
        ExoCache<String, Set<ClipboardCommand>> cache_ = this.getCache();
        Set allCommands = (Set)cache_.get((Serializable)((Object)userId));
        Set virtualCommands = (Set)virtualCache_.get((Serializable)((Object)userId));
        Map<String, ClipboardCommand> lastCommand_ = this.getLastCommandMap();
        if (allCommands != null) {
            allCommands.remove(command);
        }
        if (virtualCommands != null) {
            virtualCommands.remove(command);
        }
        Set<ClipboardCommand> commands = this.getClipboardList(userId, false);
        if (lastCommand_.containsValue(command)) {
            ClipboardCommand newLastCommand = null;
            Iterator<ClipboardCommand> iterator = commands.iterator();
            while (iterator.hasNext()) {
                ClipboardCommand cmd;
                newLastCommand = cmd = iterator.next();
            }
            lastCommand_.put(userId, newLastCommand);
        }
    }
}

