/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.util;

import java.util.Map;
import java.util.Properties;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceException;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;

public abstract class ConfigurationHelper {
    public static void overrideProperties(Properties properties, Map<?, ?> overrides) {
        for (Map.Entry<?, ?> entry : overrides.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
    }

    public static FlushMode getFlushMode(Object value) {
        FlushMode flushMode = null;
        if (value instanceof FlushMode) {
            flushMode = (FlushMode)value;
        } else if (value instanceof FlushModeType) {
            flushMode = ConfigurationHelper.getFlushMode((FlushModeType)value);
        } else if (value instanceof String) {
            flushMode = ConfigurationHelper.getFlushMode((String)value);
        }
        if (flushMode == null) {
            throw new PersistenceException("Unable to parse org.hibernate.flushMode: " + value);
        }
        return flushMode;
    }

    private static FlushMode getFlushMode(String flushMode) {
        if (flushMode == null) {
            return null;
        }
        flushMode = flushMode.toUpperCase();
        return FlushMode.valueOf((String)flushMode);
    }

    private static FlushMode getFlushMode(FlushModeType flushMode) {
        switch (flushMode) {
            case AUTO: {
                return FlushMode.AUTO;
            }
            case COMMIT: {
                return FlushMode.COMMIT;
            }
        }
        throw new AssertionFailure("Unknown FlushModeType: " + flushMode);
    }

    public static Integer getInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.valueOf((String)value);
    }

    public static Boolean getBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf((String)value);
    }

    public static CacheMode getCacheMode(Object value) {
        if (value instanceof CacheMode) {
            return (CacheMode)value;
        }
        return CacheMode.valueOf((String)((String)value));
    }
}

