/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.connector;

import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.chain.Context;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.ext.action.AdvancedAction;
import org.exoplatform.services.jcr.impl.ext.action.AdvancedActionException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class FileIndexerAction
implements AdvancedAction {
    private static final Log LOGGER = ExoLogger.getExoLogger(FileIndexerAction.class);
    private IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
    private TrashService trashService = (TrashService)CommonsUtils.getService(TrashService.class);

    public boolean execute(Context context) throws Exception {
        int eventType = (Integer)context.get((Object)InvocationContext.EVENT);
        switch (eventType) {
            case 1: {
                NodeImpl node = (NodeImpl)context.get((Object)InvocationContext.CURRENT_ITEM);
                if (node == null) break;
                if (this.trashService.isInTrash((Node)node)) {
                    this.applyIndexingOperationOnNodes(node, n -> this.indexingService.unindex("file", n.getInternalIdentifier()), n -> true);
                    break;
                }
                this.applyIndexingOperationOnNodes(node, n -> this.indexingService.index("file", n.getInternalIdentifier()), n -> true);
                break;
            }
            case 2: {
                NodeImpl node = (NodeImpl)context.get((Object)InvocationContext.CURRENT_ITEM);
                if (node == null) break;
                this.applyIndexingOperationOnNodes(node, n -> this.indexingService.unindex("file", n.getInternalIdentifier()), n -> true);
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                NodeImpl node;
                PropertyImpl property = (PropertyImpl)context.get((Object)InvocationContext.CURRENT_ITEM);
                if (property == null || (node = property.getParent()) == null || this.trashService.isInTrash((Node)node)) break;
                if (node.isNodeType("nt:resource")) {
                    node = node.getParent();
                }
                if (!node.isNodeType("nt:file")) break;
                this.indexingService.reindex("file", node.getInternalIdentifier());
                break;
            }
            case 0x4000000: {
                NodeImpl node = (NodeImpl)context.get((Object)InvocationContext.CURRENT_ITEM);
                if (node == null || this.trashService.isInTrash((Node)node)) break;
                this.applyIndexingOperationOnNodes(node, n -> this.indexingService.reindex("file", n.getInternalIdentifier()), n -> this.hasNotPrivilegeableMixin((NodeImpl)n));
            }
        }
        return true;
    }

    public void onError(Exception e, Context context) throws AdvancedActionException {
        LOGGER.error((Object)"Error while indexing file", (Throwable)e);
    }

    protected Node getNodeByPath(String path) {
        return NodeLocation.getNodeByLocation((NodeLocation)new NodeLocation(WCMCoreUtils.getRepository().getConfiguration().getName(), "collaboration", path));
    }

    protected void applyIndexingOperationOnNodes(NodeImpl node, Consumer<NodeImpl> indexingOperation, Predicate<NodeImpl> filter) {
        if (node == null) {
            return;
        }
        try {
            if (node.isNodeType("nt:file")) {
                indexingOperation.accept(node);
            }
        }
        catch (RepositoryException e) {
            LOGGER.error((Object)("Cannot get primary type of node " + node.getInternalIdentifier()), (Throwable)e);
        }
        try {
            NodeIterator nodeIterator = node.getNodes();
            while (nodeIterator.hasNext()) {
                NodeImpl childNode = (NodeImpl)nodeIterator.nextNode();
                if (!filter.test(childNode)) continue;
                this.applyIndexingOperationOnNodes(childNode, indexingOperation, filter);
            }
        }
        catch (RepositoryException e) {
            LOGGER.error((Object)("Cannot get child nodes of node " + node.getInternalIdentifier()), (Throwable)e);
        }
    }

    private boolean hasNotPrivilegeableMixin(NodeImpl node) {
        try {
            return !node.isNodeType("exo:privilegeable");
        }
        catch (RepositoryException e) {
            LOGGER.error((Object)"Error while check privilegeable mixin ", (Throwable)e);
            return true;
        }
    }
}

