/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.owasp.html.HtmlLexer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlTextEscapingMode;
import org.owasp.html.TCB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TCB
public class TagBalancingHtmlStreamEventReceiver
implements HtmlStreamEventReceiver {
    private final HtmlStreamEventReceiver underlying;
    private int nestingLimit = Integer.MAX_VALUE;
    private final List<ElementContainmentInfo> openElements = Lists.newArrayList();
    private final Deque<ElementContainmentInfo> toResumeInReverse = new ArrayDeque<ElementContainmentInfo>();
    private static final long HTML_SPACE_CHAR_BITMASK = 4294981120L;
    static final ImmutableMap<String, ElementContainmentInfo> ELEMENT_CONTAINMENT_RELATIONSHIPS = ElementContainmentRelationships.make().toMap();

    public TagBalancingHtmlStreamEventReceiver(HtmlStreamEventReceiver underlying) {
        this.underlying = underlying;
    }

    public void setNestingLimit(int limit) {
        if (this.openElements.size() > limit) {
            throw new IllegalStateException();
        }
        this.nestingLimit = limit;
    }

    @Override
    public void openDocument() {
        this.underlying.openDocument();
    }

    @Override
    public void closeDocument() {
        int i = Math.min(this.nestingLimit, this.openElements.size());
        while (--i >= 0) {
            this.underlying.closeTag(this.openElements.get((int)i).elementName);
        }
        this.openElements.clear();
        this.toResumeInReverse.clear();
        this.underlying.closeDocument();
    }

    @Override
    public void openTag(String elementName, List<String> attrs) {
        String canonElementName = HtmlLexer.canonicalName(elementName);
        ElementContainmentInfo elInfo = (ElementContainmentInfo)ELEMENT_CONTAINMENT_RELATIONSHIPS.get((Object)canonElementName);
        if (elInfo == null) {
            if (this.openElements.size() < this.nestingLimit) {
                this.underlying.openTag(elementName, attrs);
            }
            return;
        }
        this.prepareForContent(elInfo);
        if (this.openElements.size() < this.nestingLimit) {
            this.underlying.openTag(elInfo.elementName, attrs);
        }
        if (!elInfo.isVoid) {
            this.openElements.add(elInfo);
        }
    }

    private void prepareForContent(ElementContainmentInfo elInfo) {
        int nOpen = this.openElements.size();
        if (nOpen != 0) {
            ElementContainmentInfo blockContainerChild;
            ElementContainmentInfo top = this.openElements.get(nOpen - 1);
            if ((top.contents & elInfo.types) == 0 && (blockContainerChild = top.blockContainerChild) != null && (blockContainerChild.contents & elInfo.types) != 0) {
                this.underlying.openTag(blockContainerChild.elementName, Lists.newArrayList());
                this.openElements.add(blockContainerChild);
                top = blockContainerChild;
                ++nOpen;
            }
            while (!this.canContain(elInfo, top, nOpen - 1)) {
                if (this.openElements.size() < this.nestingLimit) {
                    this.underlying.closeTag(top.elementName);
                }
                this.openElements.remove(--nOpen);
                if (top.resumable) {
                    this.toResumeInReverse.add(top);
                }
                if (nOpen == 0) break;
                top = this.openElements.get(nOpen - 1);
            }
        }
        while (!this.toResumeInReverse.isEmpty()) {
            ElementContainmentInfo toResume = this.toResumeInReverse.getLast();
            nOpen = this.openElements.size();
            if (nOpen != 0 && !this.canContain(toResume, this.openElements.get(nOpen - 1), nOpen) || !this.canContain(elInfo, toResume, nOpen)) break;
            this.toResumeInReverse.removeLast();
            if (this.openElements.size() < this.nestingLimit) {
                this.underlying.openTag(toResume.elementName, Lists.newArrayList());
            }
            this.openElements.add(toResume);
        }
    }

    private boolean canContain(ElementContainmentInfo child, ElementContainmentInfo top, int topIndex) {
        int childTypes = child.types;
        int contents = top.contents;
        int transparencyAllowed = childTypes & (top.transparentToContents & ~contents);
        int containerIndex = topIndex - 1;
        while (transparencyAllowed != 0) {
            if (containerIndex < 0) {
                contents |= transparencyAllowed;
                break;
            }
            ElementContainmentInfo container = this.openElements.get(containerIndex);
            transparencyAllowed = transparencyAllowed & container.transparentToContents & ~(contents |= transparencyAllowed & container.contents);
            --containerIndex;
        }
        return (contents & childTypes) != 0;
    }

    @Override
    public void closeTag(String elementName) {
        String canonElementName = HtmlLexer.canonicalName(elementName);
        ElementContainmentInfo elInfo = (ElementContainmentInfo)ELEMENT_CONTAINMENT_RELATIONSHIPS.get((Object)canonElementName);
        if (elInfo == null) {
            if (this.openElements.size() < this.nestingLimit) {
                this.underlying.closeTag(elementName);
            }
            return;
        }
        int index = this.openElements.lastIndexOf(elInfo);
        if (TagBalancingHtmlStreamEventReceiver.isHeaderElementName(canonElementName)) {
            int i = this.openElements.size();
            int limit = index + 1;
            while (--i >= limit) {
                ElementContainmentInfo openEl = this.openElements.get(i);
                if (!TagBalancingHtmlStreamEventReceiver.isHeaderElementName(openEl.elementName)) continue;
                elInfo = openEl;
                index = i;
                canonElementName = openEl.elementName;
                break;
            }
        }
        if (index < 0) {
            return;
        }
        int blockingScopes = elInfo.blockedByScopes;
        int i = this.openElements.size();
        while (--i > index) {
            ElementContainmentInfo openElementInfo = this.openElements.get(i);
            if ((openElementInfo.inScopes & blockingScopes) == 0) continue;
            return;
        }
        int last = this.openElements.size();
        while (--last > index) {
            ElementContainmentInfo unclosed = this.openElements.remove(last);
            if (last + 1 < this.nestingLimit) {
                this.underlying.closeTag(unclosed.elementName);
            }
            if (!unclosed.resumable) continue;
            this.toResumeInReverse.add(unclosed);
        }
        if (this.openElements.size() < this.nestingLimit) {
            this.underlying.closeTag(elInfo.elementName);
        }
        this.openElements.remove(index);
    }

    public static boolean isInterElementWhitespace(String text) {
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char ch = text.charAt(i);
            if (ch <= ' ' && (0x100003600L & 1L << ch) != 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public void text(String text) {
        if (!TagBalancingHtmlStreamEventReceiver.isInterElementWhitespace(text)) {
            this.prepareForContent(ElementContainmentRelationships.CHARACTER_DATA_ONLY);
        }
        if (this.openElements.size() < this.nestingLimit) {
            this.underlying.text(text);
        }
    }

    private static boolean isHeaderElementName(String canonElementName) {
        return canonElementName.length() == 2 && canonElementName.charAt(0) == 'h' && canonElementName.charAt(1) <= '9';
    }

    static boolean allowsPlainTextualContent(String canonElementName) {
        ElementContainmentInfo info = (ElementContainmentInfo)ELEMENT_CONTAINMENT_RELATIONSHIPS.get((Object)canonElementName);
        if (info == null || (info.contents & ElementContainmentRelationships.CHARACTER_DATA_ONLY.types) != 0) {
            switch (HtmlTextEscapingMode.getModeForTag(canonElementName)) {
                case PCDATA: {
                    return true;
                }
                case RCDATA: {
                    return true;
                }
                case PLAIN_TEXT: {
                    return true;
                }
                case VOID: {
                    return false;
                }
                case CDATA: 
                case CDATA_SOMETIMES: {
                    return "xmp".equals(canonElementName) || "listing".equals(canonElementName);
                }
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementContainmentRelationships {
        private ImmutableMap.Builder<String, ElementContainmentInfo> definitions = ImmutableMap.builder();
        static final ElementContainmentInfo CHARACTER_DATA_ONLY = new ElementContainmentInfo("#text", false, ElementContainmentRelationships.elementGroupBits(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A, ElementGroup.BLOCK, ElementGroup.CHARACTER_DATA), 0, 0, null, 0);

        private ElementContainmentRelationships() {
            this.defineElement("a").types(ElementGroup.INLINE).contents(ElementGroup.INLINE_MINUS_A).transparentToContents(ElementGroup.BLOCK).define();
            this.defineElement("abbr").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("acronym").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("address").types(ElementGroup.BLOCK).contents(ElementGroup.INLINE, ElementGroup.P_ELEMENT).define();
            this.defineElement("applet").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.BLOCK, ElementGroup.INLINE, ElementGroup.PARAM_ELEMENT).inScopes(CloseTagScope.COMMON, CloseTagScope.BUTTON, CloseTagScope.LIST_ITEM).define();
            this.defineElement("area").types(ElementGroup.AREA_ELEMENT).define();
            this.defineElement("audio").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).define();
            this.defineElement("b").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("base").types(ElementGroup.HEAD_CONTENT).define();
            this.defineElement("basefont").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).define();
            this.defineElement("bdi").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("bdo").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("big").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("blink").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("blockquote").types(ElementGroup.BLOCK).contents(ElementGroup.BLOCK, ElementGroup.INLINE).define();
            this.defineElement("body").types(ElementGroup.TOP_CONTENT).contents(ElementGroup.BLOCK, ElementGroup.INLINE).define();
            this.defineElement("br").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).define();
            this.defineElement("button").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.BLOCK, ElementGroup.INLINE).inScopes(CloseTagScope.BUTTON).define();
            this.defineElement("canvas").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("caption").types(ElementGroup.TABLE_CONTENT).contents(ElementGroup.INLINE).inScopes(CloseTagScope.COMMON, CloseTagScope.BUTTON, CloseTagScope.LIST_ITEM).define();
            this.defineElement("center").types(ElementGroup.BLOCK).contents(ElementGroup.BLOCK, ElementGroup.INLINE).define();
            this.defineElement("cite").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("code").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("col").types(ElementGroup.TABLE_CONTENT, ElementGroup.COL_ELEMENT).define();
            this.defineElement("colgroup").types(ElementGroup.TABLE_CONTENT).contents(ElementGroup.COL_ELEMENT).define();
            ElementContainmentInfo DD = this.defineElement("dd").types(ElementGroup.DL_PART).contents(ElementGroup.BLOCK, ElementGroup.INLINE).define();
            this.defineElement("del").resumable().types(ElementGroup.BLOCK, ElementGroup.INLINE, ElementGroup.MIXED).contents(ElementGroup.BLOCK, ElementGroup.INLINE).define();
            this.defineElement("dfn").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("dir").types(ElementGroup.BLOCK).contents(ElementGroup.LI_ELEMENT).define();
            this.defineElement("div").types(ElementGroup.BLOCK).contents(ElementGroup.BLOCK, ElementGroup.INLINE).define();
            this.defineElement("dl").types(ElementGroup.BLOCK).contents(ElementGroup.DL_PART).blockContainerChild(DD).define();
            this.defineElement("dt").types(ElementGroup.DL_PART).contents(ElementGroup.INLINE).define();
            this.defineElement("em").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("fieldset").types(ElementGroup.BLOCK).contents(ElementGroup.BLOCK, ElementGroup.INLINE, ElementGroup.LEGEND_ELEMENT).define();
            this.defineElement("font").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("form").types(ElementGroup.BLOCK, ElementGroup.FORM_ELEMENT).contents(ElementGroup.BLOCK, ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A, ElementGroup.TR_ELEMENT, ElementGroup.TD_ELEMENT).define();
            this.defineElement("h1").types(ElementGroup.BLOCK).contents(ElementGroup.INLINE).define();
            this.defineElement("h2").types(ElementGroup.BLOCK).contents(ElementGroup.INLINE).define();
            this.defineElement("h3").types(ElementGroup.BLOCK).contents(ElementGroup.INLINE).define();
            this.defineElement("h4").types(ElementGroup.BLOCK).contents(ElementGroup.INLINE).define();
            this.defineElement("h5").types(ElementGroup.BLOCK).contents(ElementGroup.INLINE).define();
            this.defineElement("h6").types(ElementGroup.BLOCK).contents(ElementGroup.INLINE).define();
            this.defineElement("head").types(ElementGroup.TOP_CONTENT).contents(ElementGroup.HEAD_CONTENT).define();
            this.defineElement("hr").types(ElementGroup.BLOCK).define();
            this.defineElement("html").contents(ElementGroup.TOP_CONTENT).inScopes(CloseTagScope.ALL).define();
            this.defineElement("i").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("iframe").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.BLOCK, ElementGroup.INLINE).define();
            this.defineElement("img").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).define();
            this.defineElement("input").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).define();
            this.defineElement("ins").resumable().types(ElementGroup.BLOCK, ElementGroup.INLINE).contents(ElementGroup.BLOCK, ElementGroup.INLINE).define();
            this.defineElement("isindex").types(ElementGroup.INLINE).define();
            this.defineElement("kbd").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("label").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("legend").types(ElementGroup.LEGEND_ELEMENT).contents(ElementGroup.INLINE).define();
            ElementContainmentInfo LI = this.defineElement("li").types(ElementGroup.LI_ELEMENT).contents(ElementGroup.BLOCK, ElementGroup.INLINE).define();
            this.defineElement("link").types(ElementGroup.INLINE, ElementGroup.HEAD_CONTENT).define();
            this.defineElement("listing").types(ElementGroup.BLOCK).contents(ElementGroup.INLINE).define();
            this.defineElement("map").types(ElementGroup.INLINE).contents(ElementGroup.BLOCK, ElementGroup.AREA_ELEMENT).define();
            this.defineElement("meta").types(ElementGroup.HEAD_CONTENT).define();
            this.defineElement("nobr").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("noframes").types(ElementGroup.BLOCK, ElementGroup.TOP_CONTENT).contents(ElementGroup.BLOCK, ElementGroup.INLINE, ElementGroup.TOP_CONTENT).define();
            this.defineElement("noscript").types(ElementGroup.BLOCK).contents(ElementGroup.BLOCK, ElementGroup.INLINE).define();
            this.defineElement("object").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A, ElementGroup.HEAD_CONTENT).contents(ElementGroup.BLOCK, ElementGroup.INLINE, ElementGroup.PARAM_ELEMENT).inScopes(CloseTagScope.COMMON, CloseTagScope.BUTTON, CloseTagScope.LIST_ITEM).define();
            this.defineElement("ol").types(ElementGroup.BLOCK).contents(ElementGroup.LI_ELEMENT).blockContainerChild(LI).inScopes(CloseTagScope.LIST_ITEM).define();
            this.defineElement("optgroup").types(ElementGroup.OPTIONS_ELEMENT).contents(ElementGroup.OPTIONS_ELEMENT).define();
            this.defineElement("option").types(ElementGroup.OPTIONS_ELEMENT, ElementGroup.OPTION_ELEMENT).contents(ElementGroup.CHARACTER_DATA).define();
            this.defineElement("p").types(ElementGroup.BLOCK, ElementGroup.P_ELEMENT).contents(ElementGroup.INLINE, ElementGroup.TABLE_ELEMENT).define();
            this.defineElement("param").types(ElementGroup.PARAM_ELEMENT).define();
            this.defineElement("pre").types(ElementGroup.BLOCK).contents(ElementGroup.INLINE).define();
            this.defineElement("q").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("s").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("samp").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("script").types(ElementGroup.BLOCK, ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A, ElementGroup.MIXED, ElementGroup.TABLE_CONTENT, ElementGroup.HEAD_CONTENT, ElementGroup.TOP_CONTENT, ElementGroup.AREA_ELEMENT, ElementGroup.FORM_ELEMENT, ElementGroup.LEGEND_ELEMENT, ElementGroup.LI_ELEMENT, ElementGroup.DL_PART, ElementGroup.P_ELEMENT, ElementGroup.OPTIONS_ELEMENT, ElementGroup.OPTION_ELEMENT, ElementGroup.PARAM_ELEMENT, ElementGroup.TABLE_ELEMENT, ElementGroup.TR_ELEMENT, ElementGroup.TD_ELEMENT, ElementGroup.COL_ELEMENT).contents(ElementGroup.CHARACTER_DATA).define();
            this.defineElement("select").types(ElementGroup.INLINE).contents(ElementGroup.OPTIONS_ELEMENT).define();
            this.defineElement("small").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("span").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("strike").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("strong").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("style").types(ElementGroup.INLINE, ElementGroup.HEAD_CONTENT).contents(ElementGroup.CHARACTER_DATA).define();
            this.defineElement("sub").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("sup").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("table").types(ElementGroup.BLOCK, ElementGroup.TABLE_ELEMENT).contents(ElementGroup.TABLE_CONTENT, ElementGroup.FORM_ELEMENT).inScopes(CloseTagScope.ALL).define();
            this.defineElement("tbody").types(ElementGroup.TABLE_CONTENT).contents(ElementGroup.TR_ELEMENT).define();
            ElementContainmentInfo TD = this.defineElement("td").types(ElementGroup.TD_ELEMENT).contents(ElementGroup.BLOCK, ElementGroup.INLINE).inScopes(CloseTagScope.COMMON, CloseTagScope.BUTTON, CloseTagScope.LIST_ITEM).define();
            this.defineElement("textarea").types(ElementGroup.INLINE).contents(ElementGroup.CHARACTER_DATA).define();
            this.defineElement("tfoot").types(ElementGroup.TABLE_CONTENT).contents(ElementGroup.FORM_ELEMENT, ElementGroup.TR_ELEMENT, ElementGroup.TD_ELEMENT).define();
            this.defineElement("th").types(ElementGroup.TD_ELEMENT).contents(ElementGroup.BLOCK, ElementGroup.INLINE).inScopes(CloseTagScope.COMMON, CloseTagScope.BUTTON, CloseTagScope.LIST_ITEM).define();
            this.defineElement("thead").types(ElementGroup.TABLE_CONTENT).contents(ElementGroup.FORM_ELEMENT, ElementGroup.TR_ELEMENT, ElementGroup.TD_ELEMENT).define();
            this.defineElement("title").types(ElementGroup.HEAD_CONTENT).contents(ElementGroup.CHARACTER_DATA).define();
            this.defineElement("tr").types(ElementGroup.TABLE_CONTENT, ElementGroup.TR_ELEMENT).contents(ElementGroup.FORM_ELEMENT, ElementGroup.TD_ELEMENT).blockContainerChild(TD).define();
            this.defineElement("tt").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("u").resumable().types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("ul").types(ElementGroup.BLOCK).contents(ElementGroup.LI_ELEMENT).blockContainerChild(LI).inScopes(CloseTagScope.LIST_ITEM).define();
            this.defineElement("var").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).contents(ElementGroup.INLINE).define();
            this.defineElement("video").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).define();
            this.defineElement("wbr").types(ElementGroup.INLINE, ElementGroup.INLINE_MINUS_A).define();
            this.defineElement("xmp").types(ElementGroup.BLOCK).contents(ElementGroup.INLINE).define();
        }

        static ElementContainmentRelationships make() {
            return new ElementContainmentRelationships();
        }

        private static int elementGroupBits(ElementGroup ... groups) {
            int bitField = 0;
            for (ElementGroup group : groups) {
                assert (group.ordinal() < 32);
                bitField |= 1 << group.ordinal();
            }
            return bitField;
        }

        private static int scopeBits(CloseTagScope a) {
            return 1 << a.ordinal();
        }

        private static int scopeBits(CloseTagScope a, CloseTagScope b, CloseTagScope c) {
            return 1 << a.ordinal() | 1 << b.ordinal() | 1 << c.ordinal();
        }

        private ElementContainmentInfoBuilder defineElement(String elementName) {
            return new ElementContainmentInfoBuilder(elementName);
        }

        ImmutableMap<String, ElementContainmentInfo> toMap() {
            return this.definitions.build();
        }

        private final class ElementContainmentInfoBuilder {
            final String elementName;
            private boolean resumable;
            private int types;
            private int contents;
            private int transparentToContents;
            private ElementContainmentInfo blockContainerChild = null;
            private int inScopes = 0;

            ElementContainmentInfoBuilder(String elementName) {
                this.elementName = elementName;
            }

            ElementContainmentInfoBuilder resumable() {
                this.resumable = true;
                return this;
            }

            ElementContainmentInfoBuilder types(ElementGroup ... groups) {
                this.types |= ElementContainmentRelationships.elementGroupBits(groups);
                return this;
            }

            ElementContainmentInfoBuilder contents(ElementGroup ... groups) {
                this.contents |= ElementContainmentRelationships.elementGroupBits(groups);
                return this;
            }

            ElementContainmentInfoBuilder transparentToContents(ElementGroup ... groups) {
                this.transparentToContents |= ElementContainmentRelationships.elementGroupBits(groups);
                return this;
            }

            ElementContainmentInfoBuilder blockContainerChild(@Nullable ElementContainmentInfo c) {
                this.blockContainerChild = c;
                return this;
            }

            ElementContainmentInfoBuilder inScopes(CloseTagScope scopes) {
                return this.inScopes(ElementContainmentRelationships.scopeBits(scopes));
            }

            ElementContainmentInfoBuilder inScopes(CloseTagScope a, CloseTagScope b, CloseTagScope c) {
                return this.inScopes(ElementContainmentRelationships.scopeBits(a, b, c));
            }

            ElementContainmentInfoBuilder inScopes(int scopeBits) {
                this.inScopes |= scopeBits;
                return this;
            }

            ElementContainmentInfo define() {
                ElementContainmentInfo info = new ElementContainmentInfo(this.elementName, this.resumable, this.types, this.contents, this.transparentToContents, this.blockContainerChild, this.inScopes);
                ElementContainmentRelationships.this.definitions.put((Object)this.elementName, (Object)info);
                return info;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum CloseTagScope {
            COMMON,
            BUTTON,
            LIST_ITEM,
            TABLE;

            static final int ALL;

            static {
                ALL = (1 << CloseTagScope.values().length) - 1;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ElementGroup {
            BLOCK,
            INLINE,
            INLINE_MINUS_A,
            MIXED,
            TABLE_CONTENT,
            HEAD_CONTENT,
            TOP_CONTENT,
            AREA_ELEMENT,
            FORM_ELEMENT,
            LEGEND_ELEMENT,
            LI_ELEMENT,
            DL_PART,
            P_ELEMENT,
            OPTIONS_ELEMENT,
            OPTION_ELEMENT,
            PARAM_ELEMENT,
            TABLE_ELEMENT,
            TR_ELEMENT,
            TD_ELEMENT,
            COL_ELEMENT,
            CHARACTER_DATA;

        }
    }

    @Immutable
    private static final class ElementContainmentInfo {
        final String elementName;
        final boolean resumable;
        final int types;
        final int contents;
        final int transparentToContents;
        final boolean isVoid;
        @Nullable
        final ElementContainmentInfo blockContainerChild;
        final int blockedByScopes;
        final int inScopes;

        ElementContainmentInfo(String elementName, boolean resumable, int types, int contents, int transparentToContents, @Nullable ElementContainmentInfo blockContainerChild, int inScopes) {
            this.elementName = elementName;
            this.resumable = resumable;
            this.types = types;
            this.contents = contents;
            this.transparentToContents = transparentToContents;
            this.isVoid = contents == 0 && HtmlTextEscapingMode.isVoidElement(elementName);
            this.blockContainerChild = blockContainerChild;
            this.blockedByScopes = ElementContainmentRelationships.CloseTagScope.ALL & ~inScopes;
            this.inScopes = inScopes;
        }

        public String toString() {
            return "<" + this.elementName + ">";
        }
    }
}

